% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.r
\name{centrality}
\alias{centrality}
\title{Centrality (degree/EI) and bridge centrality for an network matrix}
\usage{
centrality(
  graph,
  communities = NULL,
  alpha = 1,
  posfun = abs,
  weighted = TRUE,
  signed = TRUE,
  directed = NULL,
  bridge_normalize = FALSE,
  useCommunities = "all"
)
}
\arguments{
\item{graph}{A square numeric network matrix (\verb{p x p}). Can be weighted and/or signed.
If directed, provide a non-symmetric matrix. Row and column names should be identical
and in the same order (node names).}

\item{communities}{A character vector indicating community membership of the nodes
(e.g., c("Comm1", "Comm1", "Comm2", "Comm2)).}

\item{alpha}{The tuning parameter. Defaults to 1.}

\item{posfun}{A function that converts positive and negative values to only positive.
Defaults to the absolute value.}

\item{weighted}{Logical, set to FALSE to set all edge weights to 1 or -1}

\item{signed}{Logical, set to FALSE to make all edge weights absolute.}

\item{directed}{Logical. Whether the input network is directed.
Automatically detected if set to "NULL" (the default).
Symmetric network matrices will be undirected, asymmetric matrices will be directed}

\item{bridge_normalize}{logical. Bridge centralities are divided by their highest possible value
(assuming max edge strength=1) in order to normalize by different community sizes}

\item{useCommunities}{Character string passed to \code{networktools::bridge(useCommunities = ...)}.}
}
\value{
A list with components:
\describe{
\item{degree}{Named list of numeric vectors (length \code{p}):
\code{OutDegree}, \code{InDegree}, \code{OutExpectedInfluence}, \code{InExpectedInfluence}.}
\item{bridge}{If \code{communities} is provided, the object returned by
\code{networktools::bridge()}; otherwise \code{NULL}.}
\item{meta}{List with metadata: \code{directed}, \code{alpha}, \code{weighted}, \code{signed},
and the expression name of \code{posfun}.}
}
}
\description{
Computes node centrality measures from a weighted network matrix.
Degree and expected-influence measures are obtained via
\code{\link[qgraph]{centrality}} and bridge centrality is obtained via
\code{\link[networktools]{bridge}} when communities are supplied.
}
\examples{
# Undirected signed weighted example:
W <- matrix(c(
  0,  0.4, -0.2,
  0.4, 0,   0.1,
 -0.2, 0.1, 0
), nrow = 3, byrow = TRUE)
colnames(W) <- rownames(W) <- c("A","B","C")

cent <- centrality(W)
cent$degree$OutDegree
cent$degree$OutExpectedInfluence

# Bridge centrality:
comm <- c(A = "X", B = "X", C = "Y")
cent_b <- centrality(W, communities = comm)
}
\seealso{
\code{\link[qgraph]{centrality}}, \code{\link[networktools]{bridge}}
}
