% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitdistrquantiles.R
\name{fitdistrquantiles}
\alias{fitdistrquantiles}
\title{Parameters of beta, normal or gamma distribution based on quantiles.}
\usage{
fitdistrquantiles(
  quantiles = stop("At least two quantiles must be provided"),
  probs = NULL,
  scaled = FALSE,
  distribution = "beta"
)
}
\arguments{
\item{quantiles}{Vector of quantiles.}

\item{probs}{Numeric vector of probabilities with values in [0,1].}

\item{scaled}{Used scaled least-square.}

\item{distribution}{Distribution to be fitted: beta, normal, or gamma.}
}
\value{
Parameters of beta, normal or gamma distribution based on quantiles.
}
\description{
Return the parameters of beta or gamm that fits the best the
quantiles. The vector of probabilities can be obtained from names of
quantiles.
}
\details{
fitdistrquantiles returns the parameters of beta, normal or gamma distribution
}
\examples{
\dontrun{
rd <- rbeta(100000, shape1 = 0.7, shape2 = 6.2, ncp=0)
(q <- quantile(rd, probs=c(0.025, 0.5, 0.975)))

(best <- fitdistrquantiles(quantiles = q, probs = c(0.025, 0.5, 0.975), 
                           scaled=FALSE, distribution = "beta"))
rd10000 <- rbeta(10000, shape1 = best["shape1"], shape2 = best["shape2"], ncp=best["ncp"])
quantile(rd10000, probs=c(0.025, 0.5, 0.975))

# Here the probabilities are obtained from names of quantiles
(best <- fitdistrquantiles(quantiles = q, scaled=FALSE, distribution = "beta"))
rd10000 <- rbeta(10000, shape1 = best["shape1"], shape2 = best["shape2"], ncp=best["ncp"])
quantile(rd10000, probs=c(0.025, 0.5, 0.975))

# If only two quantiles are provided, ncp cannot be fitted
(q2 <- quantile(rd, probs=c(0.025, 0.975)))
(best <- fitdistrquantiles(quantiles = q2, scaled=FALSE, distribution = "beta"))
rd10000 <- rbeta(10000, shape1 = best["shape1"], shape2 = best["shape2"])
quantile(rd10000, probs=c(0.025, 0.975))
x <- seq(from=0.00, to=1, by=0.001)
plot(x=x, y=pbeta(x, shape1 = best["shape1"], shape2 = best["shape2"]), 
     las=1, bty="n", type="l", ylim=c(0, 1))
segments(x0=q2[1], x1=q2[1], y0=0, y1=1, lty=2)
segments(x0=q2[2], x1=q2[2], y0=0, y1=1, lty=2)

(best <- fitdistrquantiles(quantiles = q, probs = c(0.025, 0.5, 0.975), 
                           scaled=FALSE, distribution = "gamma"))
rd10000 <- rgamma(10000, shape = best["shape"], scale = best["scale"])
quantile(rd10000, probs=c(0.025, 0.5, 0.975))

(best <- fitdistrquantiles(quantiles = c(10, 20, 30), probs = c(0.025, 0.5, 0.975), 
                           scaled=FALSE, distribution = "normal"))
rd10000 <- rnorm(10000, mean = best["mean"], sd = best["sd"])
quantile(rd10000, probs=c(0.025, 0.5, 0.975))
}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
