% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fst_HapDip.R
\name{allele.freq.WS}
\alias{allele.freq.WS}
\title{Compute per-window reference allele frequencies across populations}
\usage{
allele.freq.WS(
  geno.data,
  pop.file,
  contigs,
  positions,
  window.size,
  verbose = TRUE
)
}
\arguments{
\item{geno.data}{A character matrix of genotype strings with dimensions
\code{n_sites x n_individuals}, as returned by [vcf2GT()].}

\item{pop.file}{A \code{data.frame} or \code{data.table} with at least two
columns: \code{ID} (individual identifiers matching the column names of
\code{geno.data}) and \code{Pop} (population labels).}

\item{contigs}{A character vector of length \code{n_sites} containing the
contig (chromosome) name for each variant site, as returned by [vcf2GT()].}

\item{positions}{A numeric vector of length \code{n_sites} containing the
physical position (bp) of each variant site, as returned by [vcf2GT()].}

\item{window.size}{A single positive integer giving the size of each
sliding window in base pairs.}

\item{verbose}{Logical. If `TRUE` (default), print progress messages.}
}
\value{
A [data.table::data.table] with one row per population-contig-window
  combination and the following columns:
  \describe{
    \item{Pop}{Population label.}
    \item{Contig}{Contig (chromosome) name.}
    \item{Window_starts}{Genomic coordinate (bp) of the first position in
      the window.}
    \item{Window_ends}{Genomic coordinate (bp) of the last position in the
      window (\code{Window_starts + window.size - 1}).}
    \item{N_sites}{Total number of called genotype entries (diploid +
      haploid) within the window.}
    \item{Freq.A}{Frequency of the reference allele in the window, computed
      as \code{(2*N_AA + N_Aa + N_A) / (2*N_dip + N_hap)}.}
  }
}
\description{
Iterates over each population defined in \code{pop.file}, splits the
genotype data by contig, and slides a fixed-size window along each contig to
compute the reference allele frequency within that window. Both diploid
genotypes (\code{"0/0"}, \code{"0/1"}, \code{"1/1"}) and haploid genotypes
(\code{"0"}, \code{"1"}) are recognised. Allele frequency is agnostic to
ploidy. The resulting per-window frequencies are the direct input expected
by [pairwise.fst()].
}
\examples{
vcf_path <- system.file("extdata",
                        "example.vcf",
                        package = "HaploDiploidEquilibrium")
result   <- vcf2GT(vcf_path)
gt       <- result$gt_matrix
contigs  <- result$contig_vector
pos      <- result$positions

pop.file <- data.frame(ID  = colnames(gt),
                       Pop = c("PopA","PopA","PopB","PopB","PopB"))

af <- allele.freq.WS(geno.data  = gt,
                     pop.file   = pop.file,
                     contigs    = contigs,
                     positions  = pos,
                     window.size = 10000)

}
\seealso{
[pairwise.fst()] for computing Fst from the output of this
  function.
}
