% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlaps.R
\name{show_overlap_data}
\alias{show_overlap_data}
\title{Show data on peptide overlap}
\usage{
show_overlap_data(
  dat,
  protein = dat[["Protein"]][1],
  state = dat[["State"]][1],
  start = min(dat[["Start"]]),
  end = max(dat[["End"]])
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function.}

\item{protein}{chosen protein.}

\item{state}{biological state for chosen protein.}

\item{start}{start position of chosen protein.}

\item{end}{end position of chosen protein.}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Presents peptide overlap on protein sequence data, 
based on the supplied parameters.
}
\details{
The data frame presents all the peptides in given state, with
its start and end position on the protein sequence.
This data is available in the GUI.
}
\examples{
show_overlap_data(alpha_dat)

}
\seealso{
\code{\link{read_hdx}} 
\code{\link{plot_overlap}}
}
