% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmda.plot.metrics.R
\name{hmda.plot.metrics}
\alias{hmda.plot.metrics}
\title{Plot model performance metrics across a grid of models}
\usage{
hmda.plot.metrics(
  df,
  metrics = c("auc", "aucpr", "r2", "mcc", "f2"),
  criteria = "distance_percentage",
  top_models = 100,
  distance_percentage = 0.95,
  plot = TRUE,
  title = NULL
)
}
\arguments{
\item{df}{A data frame of class \code{"hmda.grid.analysis"} containing a column \code{model_ids}
and numeric metric columns.}

\item{metrics}{Character vector of column names in \code{df} to be plotted.}

\item{criteria}{Character. One of \code{"top_models"} or \code{"distance_percentage"} (default).}

\item{top_models}{Integer. Number of top rows to plot when \code{criteria = "top_models"}.}

\item{distance_percentage}{Numeric in (0, 1]. When \code{criteria = "distance_percentage"},
includes models with metric values \eqn{\ge} best(metric) * distance_percentage for at least one metric.}

\item{plot}{Logical. If \code{TRUE}, prints the plot.}

\item{title}{Character. Add title to the plot.}
}
\description{
Creates a line plot comparing multiple (maximize-type) performance metrics across a set of models.
The input data frame is typically the output of \code{hmda.grid.analysis()} and must contain
a \code{model_ids} column and one or more numeric metric columns (e.g., \code{aucpr}, \code{mcc}, \code{f2}).

The function can either plot the first \code{top_models} rows (\code{criteria = "top_models"})
or include all models that achieve at least \code{distance_percentage} times the best value
for at least one metric (\code{criteria = "distance_percentage"}).
}
\examples{
\dontrun{
  # Example: Create a hyperparameter grid for GBM models.
  predictors <- c("var1", "var2", "var3")
  response <- "target"

  # Define hyperparameter ranges
  hyper_params <- list(
    ntrees = seq(50, 150, by = 25),
    max_depth = c(5, 10, 15),
    learn_rate = c(0.01, 0.05, 0.1),
    sample_rate = c(0.8, 1.0),
    col_sample_rate = c(0.8, 1.0)
  )

  # Run the grid search
  grid <- hmda.grid(
    algorithm = "gbm",
    x = predictors,
    y = response,
    training_frame = h2o.getFrame("hmda.train.hex"),
    hyper_params = hyper_params,
    nfolds = 10,
    stopping_metric = "AUTO"
  )

  # Assess the performances of the models
  grid_performance <- hmda.grid.analysis(grid)

  # plot the metrics of models that are within 95\% of the best models
  # for each of the specified metrics
  hmda.plot.metrics(grid_performance,
                    criteria = "distance_percentage",
                    distance_percentage = 0.95,
                    metrics = c("auc", "aucpr", "r2", "mcc", "f2"))

}

}
\author{
E. F. Haghish
}
