% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glme.gev11.R
\name{time.m.gev11}
\alias{time.m.gev11}
\title{Time-varying moment estimation (GN16 method)}
\usage{
\method{time}{m.gev11}(qmax = NULL, orig.para = NULL, rob = FALSE, mdfy = TRUE)
}
\arguments{
\item{qmax}{Modified residual series from \code{make.qmax.gev11()}.}

\item{orig.para}{Initial parameter vector (mu0, mu1, sigma0, sigma1, xi).}

\item{rob}{Logical. If TRUE, use robust regression. Default is FALSE.}

\item{mdfy}{Logical. If TRUE, apply modified GN16 with updated alpha0. Default is TRUE.}
}
\value{
A list containing:
\describe{
  \item{mu_t}{Time-varying location values}
  \item{para.org}{Estimated parameters (mu0, mu1, sigma0, sigma1, xi)}
  \item{mu_t.up}{Updated time-varying location (if mdfy=TRUE)}
}
}
\description{
Internal function that implements the GN16 time-varying
moment method for non-stationary GEV11 estimation. Computes time-varying
location from the shape parameter and scale function.
}
\keyword{internal}
