% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glme.gev11.R
\name{strup.glme.gev11}
\alias{strup.glme.gev11}
\title{Strup WLS estimation for GEV11}
\usage{
strup.glme.gev11(xdat, orig.para = NULL, rob = NULL)
}
\arguments{
\item{xdat}{Numeric vector of data.}

\item{orig.para}{Initial parameter vector (mu0, mu1, sigma0, sigma1, xi).}

\item{rob}{Logical. If TRUE, use robust regression. If FALSE, use OLS.}
}
\value{
A list containing:
\describe{
  \item{strup.sta}{Stationary L-moment estimates of standardized residuals}
  \item{strup.para}{Raw Strup parameter estimates (5 parameters)}
  \item{strup.final}{Final adjusted parameter estimates (5 parameters)}
}
}
\description{
Internal function that performs weighted least squares (WLS)
estimation for the non-stationary GEV11 model using the Strup method.
Estimates location trend and log-scale parameters through iterative
regression steps.
}
\keyword{internal}
