% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsgev.R
\name{nsgev}
\alias{nsgev}
\title{Non-stationary GEV Parameter Estimation}
\usage{
nsgev(xdat, ntry = 20, ftol = 1e-06)
}
\arguments{
\item{xdat}{A numeric vector of data to be fitted (e.g., annual maximum values).}

\item{ntry}{Number of attempts for optimization (default 20).}

\item{ftol}{Function tolerance for optimization (default 1e-6).}
}
\value{
A list containing:
\itemize{
  \item \code{para.prop} - The proposed L-moment based estimates
        (mu0, mu1, sigma0, sigma1, xi).
  \item \code{precis} - Precision of the optimization.
}
}
\description{
Estimates parameters of a non-stationary Generalized Extreme Value (GEV)
distribution using the L-moment-based algorithm from Shin et al. (2025,
J. Korean Stat. Soc.).
This function combines L-moments, goodness-of-fit measures, and robust regression.

This is a convenience wrapper around \code{\link{glme.gev11}} with \code{pen="no"},
providing compatibility with the original nsgev package interface.
}
\examples{
data(Trehafod)
result <- nsgev(Trehafod$r1, ntry = 5)
print(result$para.prop)

}
\references{
Shin, Y., Shin, Y. & Park, J.-S. (2025). Building nonstationary extreme value
model using L-moments. Journal of the Korean Statistical Society, 54, 947-970.
\doi{10.1007/s42952-025-00325-3}
}
\seealso{
\code{\link{glme.gev11}} for the full GLME method with penalty functions,
  \code{\link{gado.prop_11}} for detailed estimation results.
}
\author{
Yonggwan Shin, Seokkap Ko, Jihong Park, Yire Shin, Jeong-Soo Park
}
