% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{new.kpar2}
\alias{new.kpar2}
\title{Adaptively expand or prune candidate xi set}
\usage{
new.kpar2(
  wtgd = NULL,
  numk = NULL,
  kpar = NULL,
  remove = 0.004,
  dist = 0.02,
  tre1 = 0.01,
  tre8 = 0.5
)
}
\arguments{
\item{wtgd}{Numeric vector of current weights.}

\item{numk}{Number of candidate submodels.}

\item{kpar}{Numeric vector of candidate xi values.}

\item{remove}{Threshold below which candidates are removed. Default is 0.004.}

\item{dist}{Spacing for new candidates. Default is 0.02.}

\item{tre1}{Lower threshold for boundary detection. Default is 0.01.}

\item{tre8}{Upper threshold for dominant candidate. Default is 0.5.}
}
\value{
A list containing:
\describe{
  \item{kpar2}{Updated candidate xi values}
  \item{aw}{Adjustment indicator (0 = no change needed)}
  \item{numk}{Updated number of candidates}
}
}
\description{
Internal function that adaptively adjusts the candidate xi
set by removing low-weight candidates and adding new candidates near
boundary or dominant regions to improve weight coverage.
}
\keyword{internal}
