% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glme.gev.R
\name{init.glme}
\alias{init.glme}
\title{Initialize random starting values for GLME optimization}
\usage{
init.glme(xdat, ntry = ntry)
}
\arguments{
\item{xdat}{A numeric vector of data to be fitted.}

\item{ntry}{Number of initial parameter sets to generate.}
}
\value{
A matrix with \code{ntry} rows and 3 columns (location, scale, shape),
  where each row is a candidate starting point for optimization.
}
\description{
Generates multiple random starting parameter sets for multi-start
optimization in GLME estimation. Uses L-moment estimates as a base
and adds random perturbations.
}
\examples{
data(streamflow)
inits <- init.glme(streamflow$r1, ntry = 5)
print(inits)

}
\seealso{
\code{\link{glme.gev}} which uses this function internally.
}
\author{
Yonggwan Shin, Seokkap Ko, Jihong Park, Yire Shin, Jeong-Soo Park
}
