% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gene_PPA.R
\name{Gene_PPA}
\alias{Gene_PPA}
\title{Function to estimate the posterior probability of association (PPA) based on the integration of -OMICs and functional data
via representation learning of candidate genes.}
\usage{
Gene_PPA(
  gene.pval,
  Gene_ID,
  pval,
  embeddings,
  lambda = 0,
  alpha0 = 1,
  alpha1 = 0.2,
  pi0 = 0.6,
  pi1 = 0.4,
  max.it = 10,
  model,
  verbose = F
)
}
\arguments{
\item{gene.pval}{A table containing the gene IDs and p-values.}

\item{Gene_ID}{Name of the column containing the gene IDs (without NAs or duplicated IDs).}

\item{pval}{Name of the column containing the gene-level p-values.}

\item{embeddings}{The output of the \code{Net_embedding} function.}

\item{lambda}{Ridge (\eqn{L_2}) regularization strength used only when \code{model = "LR"} for the logistic regression part that models
the prior probability of being in the signal component.}

\item{alpha0}{Mixing proportion (prior probability) that an observation belongs to the alternative/signal component \eqn{Z = 1}
in the two-component mixture; typically \eqn{\pi_1 = 1 - \pi_0}.}

\item{alpha1}{Shape parameter of the alternative/signal p-value distribution, modeled as
\eqn{p \sim \mathrm{Beta}(\alpha_1, 1)} when \eqn{Z = 1}; values \eqn{< 1} concentrate mass near 0 (enrichment of small p-values).}

\item{pi0}{Mixing proportion (prior probability) that an observation belongs to the null/background component \eqn{Z = 0}
in the two-component mixture.}

\item{pi1}{Mixing proportion (prior probability) that an observation belongs to the alternative/signal component \eqn{Z = 1}
in the two-component mixture; typically \eqn{\pi_1 = 1 - \pi_0}.}

\item{max.it}{Maximum number of iterations for the EM algorithm.}

\item{model}{One of the following options defining the model used during the EM algorithm: \code{proj}, \code{M}, \code{LR},
\code{NB}, and \code{MVN}. See Details for more information.}

\item{verbose}{A logical value defining if the iteration information should be printed or not.}
}
\value{
Returns the posterior probability of association for each gene.
}
\description{
Function to estimate the posterior probability of association (PPA) based on the integration of -OMICs and functional data
via representation learning of candidate genes.
}
\details{
The function \code{Gene_PPA} allows the user to select different options that define how the EM algorithm models the
distribution of \eqn{v} (the auxiliary information matrix (feature/annotation matrix) attached to each p-value). The EM algorithms
employed here are adapted from Wu et al. (2018):

\itemize{
\item \code{proj}: Fits a two-component mixture model that combines p-values with an LDA-based one-dimensional projection of the
  feature matrix \eqn{v}. The projection is obtained by soft LDA using current posterior weights, and class-conditional densities of
  the projected score are estimated nonparametrically via weighted KDE.
\item \code{M}: Fits a two-component mixture model that combines p-values with the feature matrix \eqn{v} by estimating a separate
  weighted KDE for each feature and each component. The joint density is approximated by the product of marginal densities
  (naive independence across features).
\item \code{LR}: Fits a two-component mixture model where p-values follow a Beta-mixture and the prior probability of belonging to the
  signal component is modeled as a logistic function of \eqn{v}. Logistic regression parameters are estimated within the EM iterations,
  with optional ridge regularization controlled by \code{lambda}.
\item \code{NB}: Fits a two-component mixture model that combines p-values with \eqn{v} assuming a Gaussian naive Bayes model for the
  features. Component-specific feature means are estimated, with feature-wise variances shared across components, and features are treated
  as conditionally independent given component membership.
\item \code{MVN}: Fits a two-component mixture model that combines p-values with \eqn{v} using a multivariate normal model with shared
  covariance (parametric, correlation-aware).
}
}
\references{
Wu et al. (2018) Methods, 145, \doi{10.1016/j.ymeth.2018.06.002}.
}
