% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{remove_noise_sor}
\alias{remove_noise_sor}
\title{Remove sparse outlier points using Statistical Outlier Removal (SOR)}
\usage{
remove_noise_sor(las, height_thresh = 5, k = 20, zscore = 2.5)
}
\arguments{
\item{las}{A \code{lidR::LAS} object.}

\item{height_thresh}{Numeric. Height (meters) above which filtering is applied.}

\item{k}{Integer. Number of nearest neighbors used by the SOR filter.}

\item{zscore}{Numeric. Standard deviation multiplier controlling outlier rejection.}
}
\value{
A filtered \code{lidR::LAS} object.
}
\description{
Applies a k-nearest-neighbor Statistical Outlier Removal (SOR) filter to points
above a user-defined height threshold. Points at or below the threshold are
preserved unchanged.
}
\details{
The filter is applied only to points with \code{Z} is greater than \code{height_thresh}.
For each of these points, the mean distance to its \code{k} nearest neighbors
is computed in 3D XYZ space. A point is kept if:
\deqn{d_i < mean(d) + zscore * sd(d)}
where \code{d_i} is the mean kNN distance for point i.

To keep behavior stable and safe, \code{k} is automatically capped so that
\code{k < n}, where \code{n} is the number of points being filtered.

This function preserves the original point order by computing a global keep
mask and subsetting once.
}
\examples{
# Check for both lidR and dbscan before running
if (requireNamespace("lidR", quietly = TRUE) && 
    requireNamespace("dbscan", quietly = TRUE)) {
  
  las <- lidR::readLAS(system.file("extdata", "las", "tree2.laz", package = "FuelDeep3D"))
  
  if (!lidR::is.empty(las)) {
    las_small <- las[seq_len(min(20000, lidR::npoints(las)))]
    las_clean <- remove_noise_sor(las_small, height_thresh = 1, k = 10, zscore = 2.5)
    
    # Optional: Print to console to show it worked
    print(lidR::npoints(las_small))
    print(lidR::npoints(las_clean))
  }
}

}
