% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{label_trans_prob}
\alias{label_trans_prob}
\title{Label transfer via k-NN (soft assignment / probabilities)}
\usage{
label_trans_prob(
  integrated,
  ref = "10X",
  query = "SS2",
  label_key = "annotation",
  emb_key = "pca",
  batch_key = "dataset",
  k = 10,
  seed = NULL
)
}
\arguments{
\item{integrated}{\link[Seurat]{Seurat} object containing the joint embedding
and meta-data.}

\item{ref}{Name of the reference dataset/batch (default \code{"10X"}).}

\item{query}{Name of the query dataset/batch (default \code{"SS2"}).}

\item{label_key}{Name of the meta-data column that stores cell-type / label
information (default \code{"annotation"}).}

\item{emb_key}{Name of the reduction to use (default \code{"pca"}).}

\item{batch_key}{Name of the meta-data column that indicates dataset/batch
origin (default \code{"dataset"}).}

\item{k}{Number of nearest neighbours to consider (default \code{10}).}

\item{seed}{Integer, random seed for reproducibility (optional). If NULL, uses current random state.}
}
\value{
Numeric matrix (query-cells × unique-labels).  Row sums equal 1.
Row names are query cell barcodes, column names are reference labels.
}
\description{
Identical to \code{\link{label_trans}} but returns a probability matrix
instead of a hard label.
}
