% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FFmatch.R
\name{FFmatch}
\alias{FFmatch}
\title{Preview fuzzy-matching results before downloading}
\usage{
FFmatch(inputlist, exclude_daily = TRUE)
}
\arguments{
\item{inputlist}{character vector of (partial) dataset names to match, as you
would pass to the \code{inputlist} argument of \code{\link{FFdownload}}.}

\item{exclude_daily}{logical. If \code{TRUE} (default), daily datasets are
excluded from the candidate pool.}
}
\value{
A data frame (or tibble) with one row per entry in \code{inputlist} and
columns:
\describe{
  \item{requested}{The input string as supplied.}
  \item{matched}{The dataset name that would be selected by \code{FFdownload}.}
  \item{edit_distance}{Raw Levenshtein edit distance between \code{requested}
    and \code{matched}.}
  \item{similarity}{1 - edit_distance / nchar(matched), clamped to [0, 1].
    Values below 0.3 suggest a potentially wrong match.}
}
}
\description{
\code{FFmatch} shows how each entry in \code{inputlist} would be
matched to an available dataset by the fuzzy-matching logic inside
\code{\link{FFdownload}}.  Use this to verify matches before triggering a
download, especially when dataset names are abbreviated or partially specified.
}
\examples{
\dontrun{
FFmatch(c("Research_Data_Factors", "Momentum", "ST_Reversal"))
}

}
