test_that("two-variable example gives WelchRankTest results", {
  x <- seq(-1, 1, length = 200)
  a <- rep(c("a", "b"), 100)
  offset <- rep(c(0, 0.2), 100)
  xMod <- x + offset
  DF <- data.frame(numVar = x, numVar2 = xMod, setVar = a)
  indexA <- which(DF$setVar == "a")
  varList <- c("numVar", "numVar2")
  sumFrame <- CompareNumericSets(DF, indexA, c("numVar", "numVar2"))
  expect_setequal(sumFrame$Variable, varList)
  nCol <- ncol(sumFrame)
  refVec <- as.numeric(WelchRankTest(DF, varList[1], indexA))
  expect_equal(as.numeric(sumFrame[1, 2:nCol]), refVec)
  refVec <- as.numeric(WelchRankTest(DF, varList[2], indexA))
  expect_equal(as.numeric(sumFrame[2, 2:nCol]), refVec)
})
