% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscreteTests-package.R
\docType{package}
\name{DiscreteTests-package}
\alias{DiscreteTests}
\alias{DiscreteTests-package}
\title{Vectorised Computation of P-Values and Their Supports for Several Discrete
Statistical Tests}
\description{
This package provides vectorised functions for computing p-values of various
discrete statistical tests. Exact and approximate computation methods are
provided. For exact p-values, several procedures of determining two-sided
p-values are included.

Additionally, these functions are capable of returning the discrete p-value
supports, i.e. all observable p-values under a null hypothesis. These
supports can be used for multiple testing procedures in the
\code{\link[DiscreteFDR:DiscreteFDR]{DiscreteFDR}} and
\code{\link[FDX:FDX-package]{FDX}} packages.
}
\references{
Fisher, R. A. (1935). The logic of inductive inference.
\emph{Journal of the Royal Statistical Society Series A}, \strong{98}, pp.
39–54. \doi{10.2307/2342435}

Agresti, A. (2002). \emph{Categorical data analysis} (2nd ed.). New York: John
Wiley & Sons. \doi{10.1002/0471249688}

Blaker, H. (2000) Confidence curves and improved exact confidence intervals
for discrete distributions. \emph{Canadian Journal of Statistics},
\strong{28}(4), pp. 783-798. \doi{10.2307/3315916}

Hirji, K. F. (2006). \emph{Exact analysis of discrete data}. New York: Chapman
and Hall/CRC. pp. 55-83. \doi{10.1201/9781420036190}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/DISOhda/DiscreteTests}
  \item Report bugs at \url{https://github.com/DISOhda/DiscreteTests/issues}
}

}
\author{
\strong{Maintainer}: Florian Junge \email{diso.fbmn@h-da.de} (\href{https://orcid.org/0009-0001-6856-6938}{ORCID})

Authors:
\itemize{
  \item Christina Kihn
}

Other contributors:
\itemize{
  \item Sebastian Döhler (\href{https://orcid.org/0000-0002-0321-6355}{ORCID}) [contributor]
  \item Guillermo Durand (\href{https://orcid.org/0000-0003-4056-5631}{ORCID}) [contributor]
}

}
