% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R, R/api.R
\name{DDESONN_training_defaults}
\alias{DDESONN_training_defaults}
\alias{ddesonn_training_defaults}
\title{Legacy alias for \code{\link[=ddesonn_training_defaults]{ddesonn_training_defaults()}}}
\usage{
DDESONN_training_defaults(...)

ddesonn_training_defaults(
  mode = c("binary", "multiclass", "regression"),
  hidden_sizes = NULL
)
}
\arguments{
\item{...}{Additional arguments passed through to
\code{\link[=ddesonn_training_defaults]{ddesonn_training_defaults()}}.}

\item{mode}{Problem mode used to determine sensible defaults.}

\item{hidden_sizes}{Integer vector describing the hidden layer widths.}
}
\value{
Same as \code{\link[=ddesonn_training_defaults]{ddesonn_training_defaults()}}.

A named list that can be modified and supplied to \code{\link[=ddesonn_fit]{ddesonn_fit()}}.
}
\description{
Build a list of training hyperparameters that mirror the
expectations of the legacy DDESONN training loop.
}
\examples{
ddesonn_training_defaults("binary", hidden_sizes = c(32, 16))

# Inspect regression defaults (includes LR decay by default).
cfg_reg <- ddesonn_training_defaults("regression", hidden_sizes = c(16, 8))
cfg_reg$lr
cfg_reg$lr_decay_rate
cfg_reg$lr_decay_epoch
cfg_reg$lr_min

# If you prefer a fixed LR in regression, disable decay explicitly.
cfg_reg$lr_decay_rate <- 1.0

}
