% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R, R/api.R
\name{DDESONN_predict}
\alias{DDESONN_predict}
\alias{ddesonn_predict}
\title{Legacy alias for \code{\link[=ddesonn_predict]{ddesonn_predict()}}}
\usage{
DDESONN_predict(...)

ddesonn_predict(
  model,
  new_data,
  aggregate = c("mean", "median", "none"),
  type = c("response", "class"),
  threshold = NULL,
  verbose = FALSE,
  verboseLow = FALSE,
  debug = FALSE
)
}
\arguments{
\item{...}{Additional arguments passed through to
\code{\link[=ddesonn_predict]{ddesonn_predict()}}.}

\item{model}{A trained model produced by \code{\link[=ddesonn_model]{ddesonn_model()}}.}

\item{new_data}{New feature matrix or data frame.}

\item{aggregate}{Aggregation strategy across ensemble members. One of
\code{"mean"}, \code{"median"}, or \code{"none"}.}

\item{type}{Prediction type. \code{"response"} returns numeric predictions,
while \code{"class"} applies thresholding for classification problems.}

\item{threshold}{Optional threshold override when \code{type = "class"}.}

\item{verbose}{Logical; emit detailed progress output when TRUE.}

\item{verboseLow}{Logical; emit important progress output when TRUE.}

\item{debug}{Logical; emit debug diagnostics when TRUE.}
}
\value{
Same as \code{\link[=ddesonn_predict]{ddesonn_predict()}}.

A list containing the aggregated prediction matrix and the
per-model outputs when \code{aggregate = "none"}.
}
\description{
Internal prediction engine / forward-pass primitive that
produces ensemble or per-model predictions from a trained \code{ddesonn_model}.
For user-facing inference, prefer \code{\link[=predict.ddesonn_model]{predict.ddesonn_model()}}, which wraps
this helper to provide a stable API for \code{type}/\code{aggregate}/\code{threshold}
handling and return shapes.
Multiclass note: For multiclass classification, y should be encoded as integer class indices 1..K (or a one-hot matrix whose columns follow the model’s class order), otherwise accuracy comparisons may be incorrect.
}
\examples{
# ============================================================
# Example 1 — Manual API (minimal, CRAN-safe)
# ============================================================
# This is the base mtcars binary classification example.
# The exact same setup is used again below in the full workflow script.

data <- mtcars
target <- "am"
features <- setdiff(colnames(data), target)

x <- data[, features]
y <- data[[target]]

model <- ddesonn_model(
  input_size = ncol(x),
  output_size = 1,
  hidden_sizes = c(32, 16),
  classification_mode = "binary",
  activation_functions = c("relu", "relu", "sigmoid"),
  activation_functions_predict = c("relu", "relu", "sigmoid"),
  num_networks = 1
)

ddesonn_fit(
  model,
  x,
  y,
  num_epochs = 3,
  lr = 0.02,
  validation_metrics = FALSE
)

preds <- ddesonn_predict(model, x)
head(preds$prediction)

# ============================================================
# Example 2 — Same example, extended (A–D scenarios)
# ============================================================
# This is the SAME mtcars example shown above.
# The only difference is that the full script adds:
# - train/validation/test splitting
# - scaling (fit on training data)
# - ensemble configurations
# - scenario orchestration (A–D)

# View the full version of this same example:
system.file("scripts", "DDESONN_mtcars_A-D_examples.R", package = "DDESONN")

# Repository path:
# /DDESONN/inst/scripts/DDESONN_mtcars_A-D_examples.R

}
\seealso{
\link{DDESONN-package}
}
