% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DDESONN-package.R
\docType{package}
\name{DDESONN-package}
\alias{DDESONN}
\alias{DDESONN-package}
\title{DDESONN: A Deep Dynamic Experimental Self-Organizing Neural Network Framework}
\description{
Provides a fully native R deep learning framework for constructing, training, evaluating, and inspecting Deep Dynamic Ensemble Self Organizing Neural Networks at research scale. The core engine is an object oriented R6 class-based implementation with explicit control over layer layout, dimensional flow, forward propagation, back-propagation, and optimizer state updates. The framework does not rely on external deep learning back ends, enabling transparent inspection of model state, reproducible numerical behavior, and fine-grained architectural control without requiring compiled dependencies or graphics processing unit specific run times. Users can define dimension agnostic single layer or deep multi-layer networks without hard coded architecture limits, then run reproducible workflows through high level helpers for fit, run, and predict across binary classification, multi-class classification, and regression modes. Training pipelines support optional self organization, adaptive learning rate behavior, and dynamic ensemble orchestration in which candidate models are evaluated under user specified performance metrics and selectively promoted to a primary ensemble, enabling structured model comparison and controlled ensemble evolution. The framework supports multiple optimization approaches, including but not limited to stochastic gradient descent, adaptive moment estimation, and look-ahead optimization, alongside configurable regularization controls such as L1, L2, and mixed penalties with separate weight and bias update blocks. Activation functions and their corresponding derivatives can be specified per model configuration. Evaluation features provide threshold tuning, relevance scoring, receiver operating characteristic and precision-recall curve generation, area under the curve and area under the precision-recall curve computation, regression error diagnostics, and report ready metric outputs. The package also includes artifact path management, debug state utilities, reproducible scripts, and vignettes that document end to end experiments.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/MatHatter/DDESONN}
  \item Report bugs at \url{https://github.com/MatHatter/DDESONN/issues}
}

}
\author{
\strong{Maintainer}: Mathew William Armitage Fok \email{quiksilver67213@yahoo.com}

}
\keyword{internal}
