% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cms_download_native.R
\name{cms_native_proxy}
\alias{cms_native_proxy}
\title{Get a proxy stars object from a native service}
\usage{
cms_native_proxy(
  product,
  layer,
  pattern,
  prefix,
  variable,
  ...,
  username = cms_get_username(),
  password = cms_get_password()
)
}
\arguments{
\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{cms_products_list}}.}

\item{layer}{The name of a desired layer within a product (type \code{character}). Can be obtained with \code{\link{cms_product_services}} (listed as \code{id} column).}

\item{pattern}{A regular expression (\href{https://en.wikipedia.org/wiki/Regular_expression}{regex})
pattern. Only paths that match the pattern will be returned. It can be used
to select specific files. For instance if \code{pattern = "2022/06/"}, only files for the
year 2022 and the month June will be listed (assuming that the file path is structured as such, see
examples)}

\item{prefix}{A \code{character} string. A prefix to be added to the search path of the files.
Only the matching file (info) is downloaded (generally faster then using \code{pattern})}

\item{variable}{The variable name for which to create the \code{stars_proxy}.
If omitted it will include all variables in the layer.}

\item{...}{Ignored}

\item{username}{Your Copernicus marine user name. Can be provided with
\code{cms_get_username()} (default), or as argument here.}

\item{password}{Your Copernicus marine password. Can be provided as
\code{cms_get_password()} (default), or as argument here.}
}
\value{
A \href{https://r-spatial.github.io/stars/articles/stars2.html#stars-proxy-objects}{\code{stars_proxy} object}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} The advantage of
\href{https://r-spatial.github.io/stars/articles/stars2.html#stars-proxy-objects}{\code{stars_proxy} objects},
is that they do not contain any data. They are therefore fast to handle
and consume only limited memory. You can still manipulate the object
lazily (like selecting slices). These operation are only executed when
calling \code{\link[stars:st_as_stars]{stars::st_as_stars()}} or \code{plot()} on the object.
}
\details{
For more details see \code{vignette("proxy")}.
}
\examples{
if (interactive()) {
  native_proxy <-
    cms_native_proxy(
      product       = "GLOBAL_ANALYSISFORECAST_PHY_001_024",
      layer         = "cmems_mod_glo_phy_anfc_0.083deg_PT1H-m",
      prefix        = "2022/06/",
      pattern       = "20220621"
    )
  plot(native_proxy["zos", 1:1000, 1:500, 1, 1], axes = TRUE)
}
}
\author{
Pepijn de Vries
}
