\name{K-fold cross-validtion for the alpha-regression}
\alias{cv.alfareg}
\title{
K-fold cross-validtion the \eqn{\alpha}-regression
}

\description{
K-fold cross-validtion the \eqn{\alpha}-regression.
}

\usage{
cv.alfareg(y, x, a = seq(0.1, 1, by = 0.1), nfolds = 10,
folds = NULL, nc = 1, seed = NULL)
}

\arguments{
\item{y}{
A matrix with compositional data. zero values are allowed.
}
\item{x}{
A matrix with the continuous predictor variables or a data frame including categorical predictor variables.
}
\item{a}{
The value of the power transformation, it has to be between -1 and 1. If zero values are present it has to be greater than 0. If \eqn{\alpha=0} the isometric log-ratio transformation is applied.
}
\item{nfolds}{
The number of folds to split the data.
}
\item{folds}{
If you have the list with the folds supply it here. You can also leave it NULL and it will create folds.
}
\item{nc}{
The number of cores to use. IF you have a multicore computer it is advisable to use more than 1. It makes the procedure faster. It is advisable to use it if you have many observations and or many variables, otherwise it will slow down th process.
}
\item{seed}{
You can specify your own seed number here or leave it NULL.
}
}

\details{
Tuning the value of \eqn{\alpha} in the \eqn{\alpha}-regression takes place using K-fold cross-validation.
}

\value{
A list including:
\item{runtime}{
The runtime required by the cross-validation.
}
\item{perf}{
A vector with the average Kullback-Leibler divergence, for every value of \eqn{\alpha}.
}
\item{opt}{
A vector with the minimum Kullback-Leibler divergence and the optimal value of \eqn{\alpha}.
}
}

\references{
Tsagris M. (2025). The \eqn{\alpha}--regression for compositional data: a unified framework for standard, spatially-lagged, spatial autoregressive and geographically-weighted regression models.
https://arxiv.org/pdf/2510.12663

Tsagris M. (2015). Regression analysis with compositional data containing zero values.
Chilean Journal of Statistics, 6(2): 47-57.
https://arxiv.org/pdf/1508.01913v1.pdf

Tsagris M.T., Preston S. and Wood A.T.A. (2011). A data-based power transformation for compositional data.
In Proceedings of the 4th Compositional Data Analysis Workshop, Girona, Spain.
https://arxiv.org/pdf/1106.1451.pdf
}

\author{
Michail Tsagris.

R implementation and documentation: Michail Tsagris \email{mtsagris@uoc.gr}.
}

%\note{
%%  ~~further notes~~
%}

\seealso{
\code{ \link{alfa.reg}, \link{cv.alfaslx}, \link{cv.gwar}, \link{me.ar}
}
}

\examples{
data(fadn)
y <- fadn[, 3:7]
x <- fadn[, 8]
mod <- cv.alfareg(y, x, a = c(0.5, 1))
}

