% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurvTypes.R
\name{get_form_joint}
\alias{get_form_joint}
\title{Interprets a Poisson joint formula and makes necessary changes to data}
\usage{
get_form_joint(formula_list, df, nthreads = as.numeric(detectCores())/2)
}
\arguments{
\item{formula_list}{a list of formula objects, each written in Colossus notation. See the Unified Equation Representation vignette for details. Each formula should include the elements specific to the specified event column. The list can include an entry named "shared" to denote shared terms. The person-year and strata columns should be the same.}

\item{df}{a data.table containing the columns of interest}

\item{nthreads}{number of threads to use, do not use more threads than available on your machine}
}
\value{
returns a class fully describing the model and the updated data
}
\description{
\code{get_form_joint} uses two event formula, a shared formula,
and data.table, to fully describe the model for a joint Poisson model.
}
\seealso{
Other Formula Interpretation: 
\code{\link{ColossusCoxSurv}()},
\code{\link{ColossusLogitSurv}()},
\code{\link{ColossusPoisSurv}()},
\code{\link{get_form}()}
}
\concept{Formula Interpretation}
