% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BFpower.props}
\alias{BFpower.props}
\title{Sample Size Determination for the Bayesian test of two proportions}
\usage{
BFpower.props(
  threshold,
  true_rate,
  a0,
  b0,
  a1,
  b1,
  a2,
  b2,
  prior_design_1 = "same",
  a1d,
  b1d,
  dp1,
  prior_design_2 = "same",
  a2d,
  b2d,
  dp2,
  n1 = NULL,
  n2 = NULL,
  type_rate = "positive",
  plot_power = FALSE,
  plot_rel = FALSE
)
}
\arguments{
\item{threshold}{Numeric scalar. Threshold of compelling evidence.}

\item{true_rate}{Numeric scalar. Targeted true positive rate (if \code{positive = "positive"}) or true negative rate (if \code{positive = "negative"}).}

\item{a0}{Numeric scalar. Alpha parameter of the Beta prior under the null hypothesis.}

\item{b0}{Numeric scalar. Beta parameter of the Beta prior under the null hypothesis.}

\item{a1}{Numeric scalar. Alpha parameter of the Beta analysis prior for group 1 under the alternative hypothesis.}

\item{b1}{Numeric scalar. Beta parameter of the Beta analysis prior for group 1 under the alternative hypothesis.}

\item{a2}{Numeric scalar. Alpha parameter of the Beta analysis prior for group 2 under the alternative hypothesis.}

\item{b2}{Numeric scalar. Beta parameter of the Beta analysis prior for group 2 under the alternative hypothesis.}

\item{prior_design_1}{Character. The design prior of group 1: \code{"beta"}, \code{"Point"}, or \code{"same"} (if \code{"same"}, the design prior is identical to the analysis prior).}

\item{a1d}{Numeric scalar. Alpha parameter of the design prior for group 1 (used if \code{model1 = "beta"}).}

\item{b1d}{Numeric scalar. Beta parameter of the design prior for group 1 (used if \code{model1 = "beta"}).}

\item{dp1}{Numeric scalar. True proportion for group 1 in the design prior (used if \code{model1 = "Point"}).}

\item{prior_design_2}{Character. The design prior of group 2: \code{"beta"}, \code{"Point"}, or \code{"same"} (if \code{"same"}, the design prior is identical to the analysis prior).}

\item{a2d}{Numeric scalar. Alpha parameter of the design prior for group 2 (used if \code{model2 = "beta"}).}

\item{b2d}{Numeric scalar. Beta parameter of the design prior for group 2 (used if \code{model2 = "beta"}).}

\item{dp2}{Numeric scalar. True proportion for group 2 in the design prior (used if \code{model2 = "Point"}).}

\item{n1}{Numeric integer. Sample size for group 1.}

\item{n2}{Numeric integer. Sample size for group 2.}

\item{type_rate}{Character. Choose \code{"positive"} to control true/false positive rates or \code{"negative"} to control true/false negative rates.}

\item{plot_power}{Logical; if TRUE, plot the power curve.}

\item{plot_rel}{Logical; if TRUE, plot the grid for the values of BF across all possible combination of x1 and x2.}
}
\value{
An object of class \code{BFpower_2p} (a list) containing:
\describe{
\item{\code{type}}{Character, always \code{"Two-proportions"}.}
\item{\code{analysis_h0}}{List of analysis prior parameters under the null, containing \code{a} and \code{b}.}
\item{\code{analysis_h1_theta_1}}{List of analysis prior parameters for group 1 under the alternative, containing \code{a} and \code{b}.}
\item{\code{analysis_h1_theta_2}}{List of analysis prior parameters for group 2 under the alternative, containing \code{a} and \code{b}.}
\item{\code{design_h1_theta_1}}{List of design prior parameters for group 1 under the alternative, containing \code{prior}, \code{a}, \code{b}, and \code{p}.}
\item{\code{design_h1_theta_2}}{List of design prior parameters for group 2 under the alternative, containing \code{prior}, \code{a}, \code{b}, and \code{p}.}
\item{\code{results}}{Data frame of probabilities of compelling and misleading evidence.}
\item{\code{grid}}{Grid used for computation.}
\item{\code{threshold}}{Threshold of compelling evidence.}
\item{\code{mode_bf}}{Character string specifying the mode (sample size determination or power calculation).}
\item{\code{plot_power}}{Logical; whether the power curve is plotted.}
\item{\code{plot_rel}}{Logical; whether the relationship between the Bayes factor and observed proportion differences is plotted.}
}
}
\description{
Perform sample size determination or calculate probabilities of compelling and misleading evidence
for a Bayesian comparison of two proportions.
}
\details{
\strong{1. Sample size determination mode (when \code{n1 = NULL} and \code{n2 = NULL}):}

If no sample sizes are provided for the two groups, the function calculates the minimum sample sizes needed to achieve the desired configuration. The user must provide:
\itemize{
\item \code{type_rate} - either \code{"positive"} to control true/false positive rates or \code{"negative"} to control true/false negative rates.
\item \code{true_rate} - the targeted true positive or true negative rate (between 0.6 and 0.999).
\item \code{threshold} - the Bayes factor threshold for compelling evidence (must be > 1).
}

The function iteratively finds the smallest sample sizes for which the probability of obtaining compelling evidence meets or exceeds \code{true_rate}.

\strong{2. Fixed-sample analysis mode (when \code{n1} and \code{n2} are supplied):}

If positive numeric sample sizes \code{n1} and \code{n2} are provided, the function computes the probabilities of obtaining compelling or misleading evidence for these fixed sample sizes. In this mode, \code{type_rate} and \code{true_rate} are ignored; only the Bayes factor threshold \code{threshold} is used.

\strong{Model specification:}

The user must specify the analysis priors under the null and alternative hypotheses using Beta parameters:
\itemize{
\item \code{a0}, \code{b0} - Beta parameters for the null hypothesis prior.
\item \code{a1}, \code{b1} - Beta parameters for the analysis prior of group 1 under the alternative hypothesis.
\item \code{a2}, \code{b2} - Beta parameters for the analysis prior of group 2 under the alternative hypothesis.
}

Design priors for the alternative hypothesis can optionally be specified:
\itemize{
\item \code{prior_design_1}, \code{a1d}, \code{b1d}, \code{dp1} - design prior for group 1 (\code{"same"} uses the analysis prior, \code{"beta"} requires Beta parameters, \code{"Point"} uses a fixed proportion).
\item \code{prior_design_2}, \code{a2d}, \code{b2d}, \code{dp2} - design prior for group 2.
}

\strong{Plotting:}

If \code{plot_power = TRUE}, a power curve is plotted showing the probability of compelling evidence as a function of sample sizes. If \code{plot_rel = TRUE}, a grid of Bayes factors across possible outcomes is plotted.
}
\examples{
BFpower.props(
threshold = 3,
true_rate = 0.8,
a0 = 1,
b0 = 1,
a1 = 156,
b1 = 339,
a2 = 151,
b2 = 339,
plot_power = TRUE,
plot_rel = TRUE)

}
