% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BF10.cor}
\alias{BF10.cor}
\title{Bayes factor for a Bayesian correlation test}
\usage{
BF10.cor(
  r,
  n,
  k,
  alpha,
  beta,
  h0,
  alternative,
  scale,
  prior_analysis,
  ROPE = NULL
)
}
\arguments{
\item{r}{Numeric scalar. Observed correlation coefficient. Must be a numeric scalar between -1 and 1.}

\item{n}{Numeric integer. Sample size. Must be a numeric scalar greater than 3.}

\item{k}{Numeric scalar. Parameter for the analysis default beta prior (\code{"d_beta"}) under the alternative hypothesis.}

\item{alpha}{Numeric scalar. Parameter for the analysis beta prior (\code{"beta"}) under the alternative hypothesis.}

\item{beta}{Numeric scalar. Parameter for the analysis beta prior (\code{"beta"}) under the alternative hypothesis.}

\item{h0}{Numeric scalar. Null value of the correlation. Must be a numeric scalar between -0.8 and 0.8.}

\item{alternative}{Character. The direction of the alternative hypothesis being tested: two-sided (\code{"two.sided"}), right-sided (\code{"greater"}), or left-sided (\code{"less"}).}

\item{scale}{Numeric scalar. Scale parameter for the analysis normal-moment prior (\code{"Moment"}). Must be > 0.}

\item{prior_analysis}{Character. Analysis prior: default beta (\code{"d_beta"}), beta (\code{"beta"}), or normal-moment (\code{"Moment"}).}

\item{ROPE}{Numeric vector. Optional numeric vector specifying bounds for an interval null hypothesis. For \code{"two.sided"}, must be two distinct finite values between -0.5 and 0.5. For \code{"greater"} or \code{"less"}, must satisfy additional bounds relative to \code{h0}.}
}
\value{
A list with class \code{"BFvalue_r"} containing:
\itemize{
\item \code{type}: "correlation"
\item \code{bf10}: Calculated Bayes factor BF10
\item \code{h0}: Null value of the correlation
\item \code{r}: Observed correlation coefficient
\item \code{n}: Sample size
\item \code{analysis_h1}: List with the analysis prior parameters: \code{prior_analysis}, \code{k}, \code{alpha}, \code{beta}, and \code{scale}.
\item \code{alternative}: the direction of the alternative hypothesis
\item \code{ROPE}: Interval bounds if specified
\item \code{p.value}: Numeric, p.value.
}
}
\description{
Calculate the Bayes factor (BF10) for a correlation coefficient, either against a point null
or an interval null hypothesis. Supports default beta (\code{"d_beta"}), stretched beta (\code{"beta"}),
and normal-moment (\code{"Moment"}) priors for the alternative hypothesis.
}
\examples{
BF10.cor(
  r = 0.3930924,
  n = 46,
  prior_analysis = "d_beta",
  k = 1,
  h0 = 0,
  alternative = "two.sided")
}
