% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesPET.R
\name{fit_censor}
\alias{fit_censor}
\title{Fit a Weibull model for random censoring times}
\usage{
fit_censor(
  t_obs,
  status_censor,
  cov = NULL,
  hyperparams_censor = list(),
  chains = 4,
  iter = 4000,
  seed = 2,
  refresh = 0,
  mc.cores = 1,
  warmup = floor(iter/2),
  control = list(adapt_delta = 0.95),
  return_fit = FALSE,
  quiet = TRUE
)
}
\arguments{
\item{t_obs}{Numeric vector of observed times \eqn{t^*_{ci}}. Must be \code{>0}.}

\item{status_censor}{Integer vector of random censoring indicators \eqn{\delta_{ci}} with values \code{0} or \code{1}.
A value of \code{1} indicates the random censoring time is observed, while
\code{0} indicates administrative censoring or event at \code{t_obs}.}

\item{cov}{Optional matrix or data frame of covariates \eqn{\boldsymbol{Z}}.
Each row corresponds to a subject and each column to a covariate.
Covariates must be numeric and are treated as linear effects in the model.
Only binary (0/1) and continuous covariates are supported.
Multilevel or categorical variables are not expanded into dummy variables;
if provided as numeric (e.g., factor codes), they are treated as continuous.
If \code{NULL} (default), a no-covariate Weibull model is fitted.}

\item{hyperparams_censor}{A named list of prior hyperparameters for the censoring model.
If it is empty (\code{list()}), default values
are assigned internally.
\itemize{
\item \code{alpha_c, beta_c}: Shape and rate parameters of the Gamma prior for
the baseline scale parameter \eqn{\lambda_{0c}}
(defaults: \eqn{0.1}, \eqn{0.1}).
\item \code{alpha_rc, beta_rc}: Shape and rate parameters of the Gamma prior for
the baseline shape parameter \eqn{\rho_c}
(defaults: \eqn{0.1}, \eqn{0.1}).
\item \code{mu_bc, sigma_bc}: Mean and standard deviation of the Normal
prior for the covariate effects \eqn{\beta_{cj}}
(defaults: \eqn{0}, \eqn{\sqrt{10}}).
}
No other hyperparameters are allowed.}

\item{chains}{Number of Markov chain Monte Carlo (MCMC) chains. Defaults to \code{4}.}

\item{iter}{Number of iterations per chain (including warmup). Defaults to \code{4000}.}

\item{seed}{Optional integer seed passed to \code{\link[rstan]{sampling}} for reproducibility. If \code{NULL},
'Stan' generates a seed internally and results may differ across runs.
Defaults to \code{2}.}

\item{refresh}{Frequency of progress updates from \code{\link[rstan]{sampling}}. Set to \code{0} (default) to suppress output.}

\item{mc.cores}{Integer. Number of CPU cores to use when executing Markov
chains in parallel via \code{\link[rstan]{sampling}}. Defaults to \code{1}.
We recommend setting \code{mc.cores} to the maximum number of processors
supported by the available hardware and memory, up to the number of
chains.}

\item{warmup}{Number of warmup (burn-in) iterations per chain. Must be strictly smaller
than \code{iter}. Defaults to \code{floor(iter / 2)}.}

\item{control}{A named list of sampler control parameters passed to
\code{\link[rstan]{sampling}}. Examples include \code{adapt_delta} and
\code{max_treedepth}.
Defaults to \code{list(adapt_delta = 0.95)}.}

\item{return_fit}{Logical; if \code{TRUE}, also return the underlying 'rstan' \code{stanfit} object.
Defaults to \code{FALSE}.}

\item{quiet}{Logical. If \code{TRUE} (default), suppress messages and diagnostic warnings
from 'Stan' during model fitting. Useful for large simulation studies.}
}
\value{
A list with the following components:
\itemize{
\item \code{rho_c}: Posterior draws of the Weibull shape parameter \eqn{\rho_c}.
\item \code{lambda_0c}: Posterior draws of the baseline Weibull scale parameter \eqn{\lambda_{0c}}.
\item \code{beta_c}: Posterior draws of the covariate log hazard ratios \eqn{\boldsymbol{\beta}_c},
or \code{NULL} if no covariates are included.
\item \code{fit}: The 'rstan' \code{stanfit} object (only if \code{return_fit = TRUE}).
}
}
\description{
Fits a Weibull proportional hazards model for random censoring times and returns
posterior draws of the Weibull shape parameter \eqn{\rho_c>0}, the baseline
scale parameter \eqn{\lambda_{0c}>0}, and, when covariates are included,
the covariate log hazard ratios \eqn{\boldsymbol{\beta}_c}.
}
\details{
Let \eqn{T_{ci}} denote the censoring time for subject \eqn{i}.
Let \eqn{\boldsymbol{Z}_i} denote the covariate vector for subject \eqn{i}
(the \eqn{i}-th row of \code{cov} when provided).
The parameterization has baseline density function
\deqn{
  f_{0c}(t) = \lambda_{0c}\,\rho_c\, t^{\rho_c-1}\exp(-\lambda_{0c}t^{\rho_c}), \quad t \ge 0.
}
The model assumes the survival function
\deqn{
  S_c(t \mid \boldsymbol{Z}_i) = \exp\{-\lambda_{0c} \, t^{\rho_c} \exp(\boldsymbol{Z}_i^\top \boldsymbol{\beta}_c)\}, \quad t \ge 0.
}
The corresponding hazard function is
\deqn{
  h_c(t \mid \boldsymbol{Z}_i) = \lambda_{0c}\,\rho_c\,t^{\rho_c-1}\exp(\boldsymbol{Z}_i^\top \boldsymbol{\beta}_c), \quad t \ge 0.
}
Note: In 'Stan', the Weibull distribution is parameterized by shape parameter \eqn{\rho_c} and
scale parameter \eqn{\sigma}, with baseline density function
\deqn{f_{0c}(t) = (\rho_c/\sigma)\, (t/\sigma)^{\rho_c-1}\, \exp(-(t/\sigma)^{\rho_c}), \quad t \ge 0.}

To match the hazard-scale parameterization above, we set
\deqn{
  \sigma_i = \{\lambda_{0c}\exp(\boldsymbol{Z}_i^\top \boldsymbol{\beta}_c)\}^{-1/\rho_c}.
}
The random censoring indicator \code{status_censor} follows the convention:
\itemize{
\item \code{0}: random censoring time observed at \code{t_obs} (density contribution),
\item \code{1}: administratively right-censored at \code{t_obs} (survival contribution).
}
}
\examples{
\dontshow{if (requireNamespace("rstan", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
data(data_example)
example_eventcensor<-data_example$example_eventcensor

## ---- fit censoring model ----
## Reduced number of chains and iterations compared to defaults
## to keep the example computationally manageable.
fit <- fit_censor(
  t_obs = example_eventcensor$time,
  status_censor = example_eventcensor$censorstatus,
  cov = example_eventcensor[,6:7],
  chains = 2,
  iter = 2000, quiet = FALSE,
  seed = 2, return_fit = TRUE
)

summary(fit$rho_c)
summary(fit$lambda_0c)
summary(fit$beta_c)
print(fit$fit)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other BayesPET model fitting: \code{\link{fit_enroll}}, \code{\link{fit_event_blind}},
\code{\link{fit_event_unblind}},
\code{\link{fit_models}}, \cr \code{\link{print.BayesPET_fit}}
}
