% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_probs.density.R
\name{ggplot_probs.density}
\alias{ggplot_probs.density}
\title{Density plot for posterior of probabilities}
\usage{
ggplot_probs.density(
  Gibbs,
  burnin = NA,
  truep = NA,
  main.title = "Posterior Densities of Cluster Probabilities",
  x.label = "Probability",
  y.label = "Density",
  cluster_names = NULL
)
}
\arguments{
\item{Gibbs}{MCMC sample simulated from \code{BCFMR} or \code{BCFMcpp} function}

\item{burnin}{Number of burn-in period. If not specified, it uses the first tenths as burn-in.}

\item{truep}{True values of probabilities. If not available, NA.}

\item{main.title}{Title of the plot. Default is "Posterior Densities of Cluster Probabilities"}

\item{x.label}{X-axis label. Default is "Probability"}

\item{y.label}{Y-axis label. Default is "Density"}

\item{cluster_names}{Character vector of cluster names. If NULL, defaults to Cluster 1, Cluster 2, etc.}
}
\value{
A ggplot object (grob from grid.arrange) with plot and legend
}
\description{
The function returns a density plot of the cluster assignment probability, p. Different color represent different Clusters.
}
