% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_four_factors_df_lineup.R
\name{do_four_factors_df_lineup}
\alias{do_four_factors_df_lineup}
\title{Four factors for lineups}
\usage{
do_four_factors_df_lineup(data_combs, team_name, type_lineup, type_period, type_opponent)
}
\arguments{
\item{data_combs}{Data frame with all the combinations of lineups.}

\item{team_name}{Name of the team.}

\item{type_lineup}{Type of lineups to analyze. Options are 'quintet', 'quartet', 'trio',
'duo' and 'single'.}

\item{type_period}{Period of interest. Options are xC, where x starts from 1. 
Common periods are from 1 to 4. Overtimes are labeled with the next numbers, such as 5C 
for the first overtime and 6C for the second one.}

\item{type_opponent}{Name of the opponent teams.}
}
\value{
A data frame with the four factors in defense and in offense for a given lineup.
}
\description{
This function computes offense and defense four factors for a given lineup.
The four factors are the effective field goal percentage (EFGP), 
the turnover percentage (TOVP), the offensive rebound percentage (ORBP) 
and the free throws rate (FTRate). They are well defined at 
\url{http://www.rawbw.com/~deano/articles/20040601_roboscout.htm} and
\url{https://www.basketball-reference.com/about/factors.html}.

As a summary, EFGP is a measure of shooting efficiency; TOVP is
the percentage of possessions where the team missed the ball; ORBP measures 
how many rebounds were offensive from the total of available rebounds, and 
FTRate is a measure of how often a team gets to the line.
}
\details{
Instead of defining the Offensive and Defensive Rebound Percentage
as mentioned in the previous links, I have computed just the Offensive
Rebound Percentage for the team and for its rivals. This makes easier
to have four facets, one per factor, in the ggplot.
}
\examples{
\dontrun{
do_four_factors_df_lineup(acb_combs, "Unicaja", "quintet", NULL, NULL)
}

}
\seealso{
\code{\link{do_four_factors_df}}
}
\author{
Guillermo Vinue
}
