% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmsim.R
\name{hmmsim}
\alias{hmmsim}
\title{Simulate a hidden Markov series and its underlying states
with zero-inflated emission distributions}
\usage{
hmmsim(n, M, prior, tpm_parm, emit_parm, zeroprop)
}
\arguments{
\item{n}{length of the simulated series}

\item{M}{number of hidden states}

\item{prior}{a vector of prior probability for each state}

\item{tpm_parm}{transition probability matrix}

\item{emit_parm}{a vector containing means for each poisson distribution}

\item{zeroprop}{a vector containing structural zero proportions in each state}
}
\value{
simulated series and corresponding states
}
\description{
Simulate a hidden Markov series and its underlying states
with zero-inflated emission distributions
}
\examples{
prior_init <- c(0.5,0.2,0.3)
emit_init <- c(10,50,100)
zeroprop <- c(0.5,0,0)
omega <- matrix(c(0.5,0.3,0.2,0.4,0.3,0.3,0.2,0.4,0.4),3,3,byrow=TRUE)
result <- hmmsim(n=1000,M=3,prior=prior_init, tpm_parm=omega,
         emit_parm=emit_init,zeroprop=zeroprop)
str(result)

}
\references{
Walter Zucchini, Iain L. MacDonald, Roland Langrock. Hidden Markov Models for 
Time Series: An Introduction Using R, Second Edition. Chapman & Hall/CRC
}
