% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae.R
\name{ae}
\alias{ae}
\title{Asymptotic Expansion}
\usage{
ae(
  model,
  xinit,
  order = 1L,
  true.parameter = list(),
  sampling = NULL,
  eps.var = "eps",
  solver = "rk4",
  verbose = FALSE
)
}
\arguments{
\item{model}{an object of \code{\link{yuima-class}} or \code{\link{yuima.model-class}}.}

\item{xinit}{initial value vector of state variables.}

\item{order}{integer. The asymptotic expansion order. Higher orders lead to better approximations but longer computational times.}

\item{true.parameter}{named list of parameters.}

\item{sampling}{a \code{\link{yuima.sampling-class}} object.}

\item{eps.var}{character. The perturbation variable.}

\item{solver}{the solver for ordinary differential equations. One of \code{"rk4"} (more accurate) or \code{"euler"} (faster).}

\item{verbose}{logical. Print on progress? Default \code{FALSE}.}
}
\value{
An object of \code{\link{yuima.ae-class}}
}
\description{
Asymptotic expansion of uni-dimensional and multi-dimensional diffusion processes.
}
\details{
If \code{sampling} is not provided, then \code{model} must be an object of \code{\link{yuima-class}} with non-empty \code{sampling}.

if \code{eps.var} does not appear in the model specification, then it is internally added in front of the diffusion matrix to apply the asymptotic expansion scheme.
}
\examples{
\dontrun{
# model
gbm <- setModel(drift = 'mu*x', diffusion = 'sigma*x', solve.variable = 'x')

# settings
xinit <- 100
par <- list(mu = 0.01, sigma = 0.2)
sampling <- setSampling(Initial = 0, Terminal = 1, n = 1000)

# asymptotic expansion
approx <- ae(model = gbm, sampling = sampling, order = 4, true.parameter = par, xinit = xinit)

# exact density
x <- seq(50, 200, by = 0.1)
exact <- dlnorm(x = x, meanlog = log(xinit)+(par$mu-0.5*par$sigma^2)*1, sdlog = par$sigma*sqrt(1))

# compare
plot(x, exact, type = 'l', ylab = "Density")
lines(x, aeDensity(x = x, ae = approx, order = 1), col = 2)
lines(x, aeDensity(x = x, ae = approx, order = 2), col = 3)
lines(x, aeDensity(x = x, ae = approx, order = 3), col = 4)
lines(x, aeDensity(x = x, ae = approx, order = 4), col = 5)
}
}
\author{
Emanuele Guidotti <emanuele.guidotti@unine.ch>
}
