% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recall.R
\name{recall}
\alias{recall}
\alias{recall.default}
\alias{recall.table}
\alias{precision}
\alias{precision.default}
\alias{precision.table}
\alias{precision.matrix}
\alias{f_meas}
\alias{f_meas.default}
\alias{f_meas.table}
\alias{recall.table}
\alias{recall.data.frame}
\alias{precision}
\alias{precision.data.frame}
\alias{precision.table}
\alias{f_meas}
\alias{f_meas.default}
\alias{f_meas.table}
\title{Calculate recall, precision and F values}
\usage{
recall(data, ...)

\method{recall}{table}(data, ...)

\method{recall}{data.frame}(data, truth, estimate, na.rm = TRUE, ...)

precision(data, ...)

\method{precision}{data.frame}(data, truth, estimate, na.rm = TRUE, ...)

\method{precision}{table}(data, ...)

f_meas(data, ...)

\method{f_meas}{default}(data, truth, estimate, beta = 1, na.rm = TRUE, ...)

\method{f_meas}{table}(data, beta = 1, ...)
}
\arguments{
\item{data}{For the default functions, a factor containing the
discrete measurements. For the \code{table} or \code{matrix}
functions, a table or matrix object, respectively, where the
true class results should be in the columns of the table.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true class results
(that is a factor). This should an unquoted column name although
this argument is passed by expression and support
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names or column positions).}

\item{estimate}{The column identifier for the predicted class
results (that is also factor). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name.}

\item{na.rm}{A logical value indicating whether \code{NA}
values should be stripped before the computation proceeds}

\item{beta}{A numeric value used to weight precision and
recall. A value of 1 is traditionally used and corresponds to
the harmonic mean of the two values but other values weight
recall beta times more important than precision.}
}
\description{
These functions calculate the recall, precision or F values of
a measurement system for finding/retrieving relevant documents
compared to reference results (the truth regarding relevance).
The measurement and "truth" data must have the same two possible
outcomes and one of the outcomes must be thought of as a
"relevant" results.
}
\details{
The recall (aka specificity) is defined as the proportion of
relevant results out of the number of samples which were
actually relevant. When there are no relevant results, recall is
not defined and a value of \code{NA} is returned.

The precision is percentage of predicted truly relevant results
of the total number of predicted relevant results and
characterizes the "purity in retrieval performance" (Buckland
and Gey, 1994).

The measure "F" is a combination of precision and recall (see
below).

There is no common convention on which factor level should
automatically be considered the relevant result.
In \code{yardstick}, the default is to use the \emph{first} level. To
change this, a global option called \code{yardstick.event_first} is
set to \code{TRUE} when the package is loaded. This can be changed
to \code{FALSE} if the last level of the factor is considered the
level of interest.

Suppose a 2x2 table with notation

\tabular{rcc}{ \tab Reference \tab \cr Predicted \tab relevant \tab
Irrelevant \cr relevant \tab A \tab B \cr Irrelevant \tab C \tab D \cr }

The formulas used here are: \deqn{recall = A/(A+C)} \deqn{precision =
A/(A+B)} \deqn{F_i = (1+i^2)*prec*recall/((i^2 * precision)+recall)}

See the references for discussions of the statistics.

If more than one statistic is required, it is more
computationally efficient to create the confusion matrix using
\code{\link[=conf_mat]{conf_mat()}} and applying the corresponding \code{summary} method
(\code{\link[=summary.conf_mat]{summary.conf_mat()}}) to get the values at once.
}
\examples{
data("two_class_example")

# Different methods for calling the functions:
precision(two_class_example, truth = truth, estimate = predicted)

recall(two_class_example, truth = "truth", estimate = "predicted")

truth_var <- quote(truth)
f_meas(two_class_example, !! truth_var, predicted)
}
\references{
Buckland, M., & Gey, F. (1994). The relationship
between Recall and Precision. \emph{Journal of the American Society
for Information Science}, 45(1), 12-19.

Powers, D. (2007). Evaluation: From Precision, Recall and F
Factor to ROC, Informedness, Markedness and Correlation.
Technical Report SIE-07-001, Flinders University
}
\seealso{
\code{\link[=conf_mat]{conf_mat()}}, \code{\link[=summary.conf_mat]{summary.conf_mat()}}, \code{\link[=sens]{sens()}}, \code{\link[=mcc]{mcc()}}
}
\keyword{manip}
