% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absval.dcwres.vs.cov.model.comp.R,
%   R/absval.dipred.vs.cov.model.comp.R, R/absval.diwres.vs.cov.model.comp.R,
%   R/absval.dpred.vs.cov.model.comp.R, R/absval.dwres.vs.cov.model.comp.R
\name{absval_delta_vs_cov_model_comp}
\alias{absval_delta_vs_cov_model_comp}
\alias{absval.dcwres.vs.cov.model.comp}
\alias{absval.dipred.vs.cov.model.comp}
\alias{absval.diwres.vs.cov.model.comp}
\alias{absval.dpred.vs.cov.model.comp}
\alias{absval.dwres.vs.cov.model.comp}
\title{Model comparison plots, of absolute differences in goodness-of-fit
predictors against covariates, for Xpose 4}
\usage{
absval.dcwres.vs.cov.model.comp(
  object,
  object.ref = NULL,
  type = NULL,
  ylb = expression(paste("|", Delta, "CWRES|")),
  main = "Default",
  ...
)

absval.dipred.vs.cov.model.comp(
  object,
  object.ref = NULL,
  type = NULL,
  ylb = expression(paste("|", Delta, "IPRED|")),
  main = "Default",
  ...
)

absval.diwres.vs.cov.model.comp(
  object,
  object.ref = NULL,
  type = NULL,
  ylb = expression(paste("|", Delta, "IWRES|")),
  main = "Default",
  ...
)

absval.dpred.vs.cov.model.comp(
  object,
  object.ref = NULL,
  type = NULL,
  ylb = expression(paste("|", Delta, "PRED|")),
  main = "Default",
  ...
)

absval.dwres.vs.cov.model.comp(
  object,
  object.ref = NULL,
  type = NULL,
  ylb = expression(paste("|", Delta, "WRES|")),
  main = "Default",
  ...
)
}
\arguments{
\item{object}{An xpose.data object.}

\item{object.ref}{An xpose.data object. If not supplied, the user will be
prompted.}

\item{type}{1-character string giving the type of plot desired.  The
following values are possible, for details, see 'plot': '"p"' for points,
'"l"' for lines, '"o"' for over-plotted points and lines, '"b"', '"c"') for
(empty if '"c"') points joined by lines, '"s"' and '"S"' for stair steps and
'"h"' for histogram-like vertical lines.  Finally, '"n"' does not produce
any points or lines.}

\item{ylb}{A string giving the label for the y-axis. \code{NULL} if none.}

\item{main}{The title of the plot.  If \code{"Default"} then a default title
is plotted. Otherwise the value should be a string like \code{"my title"} or
\code{NULL} for no plot title.}

\item{\dots}{Other arguments passed to \code{link{xpose.plot.default}}.}
}
\value{
Returns a stack of plots comprising comparisons of PRED, IPRED, WRES
(or CWRES) and IWRES for the two specified runs.
}
\description{
These functions plot absolute differences in PRED, IPRED, WRES, CWRES and
IWRES against covariates for two specified model fits.
}
\details{
Conditional weighted residuals (CWRES) may require some extra steps to
calculate. See \code{\link{compute.cwres}} for details.

A wide array of extra options controlling xyplots are available. See
\code{\link{xpose.plot.default}} for details.
}
\section{Functions}{
\itemize{
\item \code{absval.dcwres.vs.cov.model.comp}: The absolute differences in individual predictions
against covariates for two specified model fits.

\item \code{absval.dipred.vs.cov.model.comp}: The absolute differences in individual predictions
against covariates for two specified model fits.

\item \code{absval.diwres.vs.cov.model.comp}: The absolute differences in individual weighted
 residuals
against covariates for two specified model fits.

\item \code{absval.dpred.vs.cov.model.comp}: The absolute differences in population predictions
against covariates for two specified model fits.

\item \code{absval.dwres.vs.cov.model.comp}: The absolute differences in 
population weighted residuals
against covariates for two specified model fits.
}}

\examples{

\dontrun{
## We expect to find the required NONMEM run and table files for runs
## 5 and 6 in the current working directory
xpdb5 <- xpose.data(5)
xpdb6 <- xpose.data(6)

## A basic dWRES plot, without prompts
absval.dwres.vs.cov.model.comp(xpdb5, xpdb6)

## Custom colours and symbols, no user IDs
absval.dpred.vs.cov.model.comp(xpdb5, xpdb6, cex=0.6, pch=8, col=1, ids=NULL)
}


}
\seealso{
\code{\link{xpose.plot.default}},
\code{\link{xpose.panel.default}}, \code{\link[lattice]{xyplot}},
\code{\link{compute.cwres}}, \code{\link{xpose.prefs-class}},
\code{\link{xpose.data-class}}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{dv.vs.pred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ind.plots}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins
}
\concept{specific functions}
\keyword{methods}
