% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose.data.R
\name{xpose.data}
\alias{xpose.data}
\title{Create an Xpose data object}
\usage{
xpose.data(runno, tab.suffix = "", sim.suffix = "sim", cwres.suffix = "",
  directory = "", quiet = TRUE, table.names = c("sdtab", "mutab", "patab",
  "catab", "cotab", "mytab", "extra", "xptab", "cwtab"),
  cwres.name = c("cwtab"), mod.prefix = "run", mod.suffix = ".mod",
  phi.suffix = ".phi", phi.file = NULL, nm7 = NULL, ...)
}
\arguments{
\item{runno}{Run number of the table files to read.}

\item{tab.suffix}{Suffix to be appended to the table file names for the 
"real" data.}

\item{sim.suffix}{Suffix to be appended to the table file names for any 
simulated data.}

\item{cwres.suffix}{Suffix to be appended to the table file names for any 
CWRES data.}

\item{directory}{Where the files are located.}

\item{quiet}{A logical value indicating if more diagnostic messages should be
printed when running this function.}

\item{table.names}{Default text that Xpose looks for when searching for table
files.}

\item{cwres.name}{default text that xpose looks for when searching for CWRES 
table files.}

\item{mod.prefix}{Start of model file name.}

\item{mod.suffix}{End of model file name.}

\item{phi.suffix}{End of .phi file name.}

\item{phi.file}{The name of the .phi file. If not \code{NULL} then supersedes
\code{paste(mod.prefix,runno,phi.suffix,sep="")}.}

\item{nm7}{\code{T/F} if table files are for NONMEM 7/6, NULL for undefined.}

\item{\dots}{Extra arguments passed to function.}
}
\value{
An \code{xpose.data} object.  Default values for this object are 
  created from a file called 'xpose.ini'.  This file can be found in the root
  directory of the 'xpose4' package: 
  
  \code{system.file("xpose.ini",package="xpose4")}.  
  
  
  It can be modified to fit the users 
  wants and placed in the home folder of the user or the working directory, 
  to override default settings.
}
\description{
Creates an \code{xpose.data} object.
}
\details{
Xpose expects, by default, to find at least one the the following NONMEM 
tables in the working directory to be able to create an Xpose data object 
(using a run number of '5' as an example):

sdtab5: The 'standard' parameters, including IWRE, IPRE, TIME, and the NONMEM
default items (DV, PRED, RES and WRES) that are added when NOAPPEND is not 
present in the \code{$TABLE} record.

\code{$TABLE ID TIME IPRE IWRE NOPRINT ONEHEADER FILE=sdtab5}

patab5: The empirical Bayes estimates of individual model parameter values, 
or posthoc estimates. These are model parameters, such as CL, V2, ETA1, etc.

\code{$TABLE ID CL V2 KA K F1 ETA1 ETA2 ETA3 NOPRINT NOAPPEND ONEHEADER 
FILE=patab5 }

catab5: Categorical covariates, e.g. SEX, RACE.

\code{$TABLE ID SEX HIV GRP NOPRINT NOAPPEND ONEHEADER FILE=catab5 }

cotab5: Continuous covariates, e.g. WT, AGE.

\code{$TABLE ID WT AGE BSA HT GGT HB NOPRINT NOAPPEND ONEHEADER FILE=cotab5}

mutab5, mytab5, extra5, xptab5: Additional variables of any kind. These might
be useful if there are more covariates than can be accommodated in the 
covariates tables, for example, or if you have other variables that should be
added, e.g. CMAX, AUC.

The default names for table files can be changed by changing the default 
values to the function.  The files that Xpose looks for by default are:

\code{ paste(table.names, runno, tab.suffix, sep="") }

The default CWRES table file name is called:

\code{paste(cwres.name,runno,cwres.suffix,tab.suffix,sep="")}

If there are simulation files present then Xpose looks for the files to be 
named:

\code{paste(table.names, runno, sim.suffix, tab.suffix, sep="")} 
\code{paste(cwres.name,runno,sim.suffix,cwres.suffix,tab.suffix,sep="") }

This is basically a wrapper function for the \code{read.nm.tables}, 
\code{Data} and \code{SData} functions. See them for further information.

Also reads in the .phi file associated with the run (Individual OFVs, 
parameters, and variances of those parameters.)
}
\examples{
# Here we create files from an example NONMEM run
 
od = setwd(tempdir()) # move to a temp directory
(cur.files <- dir()) # current files in temp directory

simprazExample(overwrite=TRUE) # write files
(new.files <- dir()[!(dir() \%in\% cur.files)])  # what files are new here?

xpdb <- xpose.data(1)


file.remove(new.files) # remove these files
setwd(od)  # restore working directory


\dontrun{

# We expect to find the required NONMEM run and table files for run
# 5 in the current working directory, and that the table files have
# a suffix of '.dat', e.g. sdtab5.dat
xpdb5 <- xpose.data(5, tab.suffix = ".dat") 
}

}
\seealso{
\code{\link{xpose.data-class}}, \code{\link{Data}}, 
  \code{\link{SData}}, \code{\link{read.nm.tables}}, 
  \code{\link{compute.cwres}}

Other data functions: \code{\link{add_transformed_columns}},
  \code{\link{change_graphical_parameters}},
  \code{\link{change_misc_parameters}},
  \code{\link{compute.cwres}}, \code{\link{data.checkout}},
  \code{\link{data_extract_or_assign}},
  \code{\link{db.names}}, \code{\link{export.graph.par}},
  \code{\link{export.variable.definitions}},
  \code{\link{import.graph.par}},
  \code{\link{import.variable.definitions}},
  \code{\link{make.sb.data}}, \code{\link{nsim}},
  \code{\link{par_cov_summary}},
  \code{\link{read.TTE.sim.data}},
  \code{\link{read.nm.tables}},
  \code{\link{read_NM_output}},
  \code{\link{read_nm_table}},
  \code{\link{simprazExample}},
  \code{\link{tabulate.parameters}}, \code{\link{xlabel}},
  \code{\link{xpose.print}}, \code{\link{xpose4-package}},
  \code{\link{xsubset}}
}
\author{
Niclas Jonsson, Andrew Hooker
}
\keyword{methods}
