% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_drugtarget.R
\docType{data}
\name{drugTargetInteraction}
\alias{drugTargetInteraction}
\alias{drugtarget}
\alias{drugSim}
\alias{targetSim}
\title{drug target interactions for neural receptors}
\format{\itemize{
  \item for drugTargetInteraction: a numeric matrix of 26 rows by
54 columns.
  \item For drugSim: a numeric square matrix with 54 rows/columns.
  \item For targetSim: a numeric square matrix with 26 rows/columns.
}}
\source{
\url{https://doi.org/10.1093/bioinformatics/btn162}
}
\usage{
drugTargetInteraction
}
\description{
A dataset for examining the interaction between 54 drugs and 26
neural receptors. It consists of three different matrices.
}
\details{
The dataset consists of the following objects :

\itemize{
  \item drugTargetInteraction: a matrix indicating whether or not a
  certain drug compound interacts with a certain neural receptor.
  \item targetSim: a similarity matrix for the neural receptors.
  \item drugSim: a similarity matrix for the drugs
}

The data originates from Yamanishi et al (2008) but was partly reworked
to be suitable for two-step kernel ridge regression. This is explained
in detail in  the \href{../doc/Preparation_example_data.html}{Preparation of
the example data} vignette.
}
\references{
\href{https://doi.org/10.1093/bioinformatics/btn162}{Yamanishi et al, 2008} : Prediction of drug-target interaction networks from the
integration of chemical and genomic spaces.
}
\keyword{datasets}
