% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/share_again.R
\name{share_again}
\alias{share_again}
\alias{use_share_again}
\alias{style_share_again}
\title{Share or Embed xaringan Slides}
\usage{
use_share_again()

style_share_again(
  foreground = "rgb(255, 255, 255)",
  background = "rgba(0, 0, 0, 0.5)",
  share_buttons = c("all", "none", "twitter", "facebook", "linkedin", "pinterest",
    "pocket", "reddit")
)
}
\arguments{
\item{foreground}{The foreground color of the buttons and text in the share bar}

\item{background}{The background color of the share bar}

\item{share_buttons}{A vector of social media platforms to be included in the
share menu of the share bar. You can include \code{"all"} sites or \code{"none"} of
buttons, and if either are included in \code{share_buttons}, then the rest of
the vector is ignored. (And \code{"all"} takes precedence over \code{"none"}.) The
\emph{copy link} option is always included.}
}
\value{
An \code{htmltools::tagList()} with the HTML dependencies required for
\strong{share again}.
}
\description{
The \emph{share again} extension helps you share your xaringan slides. Adding the
extension to your slides with \code{use_share_again()} enables a "share" bar that
only appears when your slides are embedded in a web page in an \verb{<iframe>}. To
embed your presentation in another page, like a blogdown post or a R Markdown
based site, use \code{embed_xaringan()}. This function adds your slides in a
responsive aspect ratio container that seamlessly includes your slides in
the page. Finally, for perfect looking slides, use \code{style_share_again()} to
style the share bar to match your slides' aesthetic. You can also use this
function to enable or disable specific social media sites and platforms from
the share menu.
}
\section{Functions}{
\itemize{
\item \code{use_share_again}: Add the \emph{share again} bar to your slides (only shown
when embedded in an \verb{<iframe>})

\item \code{style_share_again}: Style the \emph{share again} bar to match your slides, or
choose the social media sites included in the share menu
}}

\examples{
# In your slides call
use_share_again()

# In the document where you want to embed the slides call
embed_xaringan("https://slides.yihui.org/xaringan/")

}
\seealso{
\code{\link[=embed_xaringan]{embed_xaringan()}}
}
