% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordOfFilt.R
\name{coordOfFilt}
\alias{coordOfFilt}
\title{get coordinates of values/points in matrix according to filtering condition}
\usage{
coordOfFilt(mat, cond, sortByRows = FALSE, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{mat}{(matrix or data.frame) matrix or data.frame}

\item{cond}{(logical or integer) condition/test to see which values of \code{mat} fulfull test, or integer of index passing}

\item{sortByRows}{(logical) optional sorting of results by row-index}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
matrix columns 'row' and 'col'
}
\description{
Get coordinates of values/points in matrix according to filtering condition
}
\examples{
set.seed(2021); ma1 <- matrix(sample.int(n=40,size=27,replace=TRUE), ncol=9)
## let's test which values are >37
which(ma1 >37)      # doesn't tell which row & col
coordOfFilt(ma1, ma1 >37)

}
\seealso{
\code{\link[base]{which}}
}
