% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotResults.R
\name{plotResult}
\alias{plotResult}
\title{Plot the best Results}
\usage{
plotResult(result, Polygon1, best = 3, plotEn = 1, topographie = FALSE,
  Grid, Projection, sourceCCLRoughness, sourceCCL, weibullsrc)
}
\arguments{
\item{result}{An output matrix of the function \code{\link{windfarmGA}} or
\code{\link{genAlgo}}, which has stored all relevant information. (matrix)}

\item{Polygon1}{The considered area as shapefile. (SpatialPolygons)}

\item{best}{A numeric value indicating how many of the best individuals
should be plotted. (numeric)}

\item{plotEn}{A numeric value that indicates if the best energy or
efficiency output should be plotted. If (plotEn==1) plots the best energy
solutions and (plotEn==2) plots the best efficiency solutions. (numeric)}

\item{topographie}{A logical value, indicating whether terrain effects
should be considered and plotted or not. (logical)}

\item{Grid}{The grid as SpatialPolygons, which is obtained from
\code{\link{GridFilter}} and used for plotting.}

\item{Projection}{A desired Projection can be used instead
of the default Lambert Azimuthal Equal Area Projection. (character)}

\item{sourceCCLRoughness}{The source to the adapted
Corine Land Cover legend as .csv file. Only required when terrain
effect model is activated. As default a .csv file within this
package (\file{~/extdata}) is taken that was already adapted
manually. To use your own}

\item{sourceCCL}{The source to the Corine Land Cover raster (.tif). Only
required, when the terrain effect model is activated. (character)}

\item{weibullsrc}{A list of Weibull parameter rasters, where the first list
item must be the shape parameter raster k and the second item must be the
scale parameter raster a of the Weibull distribution. If no list is given,
then rasters included in the package are used instead, which currently
only cover Austria. This variable is only used if weibull==TRUE. (list)}
}
\value{
Returns a data.frame of the best (energy/efficiency) individual
during all iterations. (data.frame)
}
\description{
Plot the best resulting solutions of the genetic algorithm.
Depending on \code{plotEn}, either the best energy or efficiency solutions
can be plotted. \code{best} indicates the amount of best solutions that
should be plotted.
}
\examples{
\donttest{
## Add some data examples from the package
load(file = system.file("extdata/resultrect.rda", package = "windfarmGA"))
load(file = system.file("extdata/resulthex.rda", package = "windfarmGA"))
load(file = system.file("extdata/polygon.rda", package = "windfarmGA"))

## Plot the results of a hexagonal grid optimization
result <- resulthex
Polygon1 <- polygon
Grid <- HexaTex(Polygon1, size = 87.5, FALSE)
plotResult(result, Polygon1, best = 1, plotEn = 1, topographie = FALSE,
           Grid = Grid[[2]])

## Plot the results of a rectangular grid optimization
result <- resultrect
Polygon1 <- polygon
Grid <- GridFilter(Polygon1, resol = 175, 1, FALSE)
plotResult(result, Polygon1, best = 1, plotEn = 1, topographie = FALSE,
           Grid = Grid[[2]])

## Plot the results of with a weibull mean background
result <- resultrect
Polygon1 <- polygon
load(file = system.file("extdata/a_weibull.rda", package = "windfarmGA"))
load(file = system.file("extdata/k_weibull.rda", package = "windfarmGA"))
weibullsrc <- list(k_param, a_param)
plotResult(result, Polygon1, best = 2, plotEn = 2, topographie = FALSE,
           Grid = Grid[[2]], weibullsrc = weibullsrc)

## Plot the hexagonal results ith weibull mean background
result <- resulthex
Grid <- HexaTex(Polygon1, size = 87.5, FALSE)
plotResult(result, Polygon1, best = 2, plotEn = 2, topographie = FALSE,
           Grid = Grid[[2]], weibullsrc = weibullsrc)
}
}
\author{
Sebastian Gatscha
}
