% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_analysis.R
\name{wbt_panchromatic_sharpening}
\alias{wbt_panchromatic_sharpening}
\title{Panchromatic sharpening}
\usage{
wbt_panchromatic_sharpening(
  pan,
  output,
  red = NULL,
  green = NULL,
  blue = NULL,
  composite = NULL,
  method = "brovey",
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{pan}{Input panchromatic band file.}

\item{output}{Output colour composite file.}

\item{red}{Input red band image file. Optionally specified if colour-composite not specified.}

\item{green}{Input green band image file. Optionally specified if colour-composite not specified.}

\item{blue}{Input blue band image file. Optionally specified if colour-composite not specified.}

\item{composite}{Input colour-composite image file. Only used if individual bands are not specified.}

\item{method}{Options include 'brovey' (default) and 'ihs'.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Increases the spatial resolution of image data by combining multispectral bands with panchromatic data.
}
