% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikidata.R
\name{wd_ident}
\alias{wd_ident}
\title{Retrieve Indentifiers from Wikidata}
\usage{
wd_ident(id, verbose = TRUE)
}
\arguments{
\item{id}{character; identifier, as returned by \code{\link{get_wdid}}}

\item{verbose}{logical; print message during processing to console?}
}
\value{
A data.frame of identifiers. Currently these are 'smiles', 'cas', 'cid', 'einecs', 'csid', 'inchi', 'inchikey',
'drugbank', 'zvg', 'chebi', 'chembl', 'unii' and source_url.
}
\description{
Retrieve Indentifiers from Wikidata
}
\note{
Only matches in labels are returned. If more than one unique hit is found,
only the first is returned.
}
\examples{
\dontrun{
 id <- c("Q408646", "Q18216")
 wd_ident(id)
}
}
\references{
Willighagen, E., 2015. Getting CAS registry numbers out of WikiData. The Winnower.
\url{http://dx.doi.org/10.15200/winn.142867.72538}

Mitraka, Elvira, Andra Waagmeester, Sebastian Burgstaller-Muehlbacher, et al. 2015
Wikidata: A Platform for Data Integration and Dissemination for the Life Sciences and beyond. bioRxiv: 031971.
}
\seealso{
\code{\link{get_wdid}}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
