% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alanwood.R
\name{aw_query}
\alias{aw_query}
\title{Query http://www.alanwood.net/pesticides}
\usage{
aw_query(query, type = c("commonname", "cas"), verbose = TRUE, idx = NULL)
}
\arguments{
\item{query}{character; search string}

\item{type}{character; type of input ('cas' or 'commonname')}

\item{verbose}{logical; print message during processing to console?}

\item{idx}{data.frame; index to use. If NULL (default) the internal index \code{\link{aw_idx}} is used.
To rebuild the index use \code{\link{build_aw_idx}}.}
}
\value{
A list of eight entries: common-name, status, preferredd IUPAC Name,
         IUPAC Name, cas, formula, activity, subactivity, inchikey, inchi and source url.
}
\description{
Query Alan Woods Compendium of Pesticide Common Names \url{http://www.alanwood.net/pesticides}
}
\note{
for type = 'cas' only the first matched link is returned.
Please respect Copyright, Terms and Conditions \url{http://www.alanwood.net/pesticides/legal.html}!
}
\examples{
\dontrun{
aw_query('Fluazinam', type = 'commonname')
out <- aw_query(c('Fluazinam', 'Diclofop'), type = 'com')
out
# extract subactivity from object
sapply(out, function(y) y$subactivity[1])

# use CAS-numbers
aw_query("79622-59-6", type = 'cas')
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}

