% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rewire.R
\name{dprewire_directed}
\alias{dprewire_directed}
\title{Degree preserving rewiring for directed networks}
\usage{
dprewire_directed(
  edgelist,
  eta,
  iteration = 1,
  nattempts = NULL,
  rewire.history = FALSE
)
}
\arguments{
\item{edgelist}{A two column matrix, each row represents a directed edge from
the first column to the second column.}

\item{eta}{An matrix, target structure eta generated by
\code{wdnet::get_eta_directed()}.}

\item{iteration}{An integer, number of rewiring iterations, each iteration
consists of \code{nattempts} rewiring attempts.}

\item{nattempts}{An integer, number of rewiring attempts for each iteration.
Default value equals the number of rows of edgelist.}

\item{rewire.history}{Logical, whether the rewiring history should be
returned.}
}
\value{
Rewired edgelist, degree based assortativity coefficients after each
  iteration, rewiring history (including the index of sampled edges and
  rewiring result). For each rewiring attempt, two rows are sampled form the
  edgelist, for example Edge1:(v_1, v_2) and Edge2:(v_3, v_4), if the
  rewiring attempt is accepted, the sampled edges are replaced as (v_1, v_4),
  (v_3, v_2).
}
\description{
Degree preserving rewiring towards the target structure \code{eta}.
}
