% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalties.R
\name{mbic.penalty}
\alias{mbic.penalty}
\title{Modified Bayes Information Criterion penalty term}
\usage{
mbic.penalty(n, cpt)
}
\arguments{
\item{n}{the number of observations}

\item{cpt}{a vector with localisations of change-points}
}
\value{
the penalty term \deqn{\frac{3}{2}k\log(n)+\frac{1}{2}\sum_{i=1}^{k+1}\log\frac{l_{i}}{n},}{3/2 * k * log(n)+1/2 * sum_i^k+1 log(l_i)/n,} where  \eqn{k}{k} denotes the number of elements in \code{cpt} and \eqn{l_{i}}{l_i} are the lengths of the intervals between changepoints in \code{cpt}
}
\description{
The function evaluates the penalty term for the  Modified Bayes Information Criterion proposed in N. Zhang and D. Siegmund (2007). This routine is typically not called directly by the user; its name can be passed as an argument to \code{\link{changepoints}}.
}
\examples{
x <- rnorm(300) + c(rep(1,50),rep(0,250))
w <- wbs(x)
w.cpt <- changepoints(w,penalty="mbic.penalty")
w.cpt$cpt.ic
}
\references{
N. Zhang and D. Siegmund (2007), A modified Bayes information criterion with applications to the analysis of comparative genomic hybridization data, Biometrics.
}
