% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ids_bulk_files.R
\name{ids_bulk_files}
\alias{ids_bulk_files}
\title{Retrieve Available Bulk Download Files for International Debt Statistics}
\usage{
ids_bulk_files()
}
\value{
A tibble containing the available files and their metadata:
\describe{
\item{file_name}{The name of the file available for download.}
\item{file_url}{The URL to download the file in Excel format.}
\item{last_updated_date}{The date when the file was last updated.}
}
}
\description{
This function returns a tibble with metadata for files available for bulk
download via the World Bank International Debt Statistics (IDS). It includes
information such as file names, URLs, and the last update dates for each file
in Excel (xlsx) format.
}
\examples{
\dontshow{if (curl::has_internet() && rlang::is_installed("jsonlite")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ids_bulk_files()
\dontshow{\}) # examplesIf}
}
