\name{importDVs}
\alias{importDVs}
\title{Imports daily USGS hydrologic times series data}
\format{The returned data frame has the following columns \cr
\tabular{lll}{
Name \tab Type \tab Description \cr
staid \tab factor \tab USGS station identification number \cr
val \tab numeric \tab The value of the hydrologic variable \cr
dates \tab Date \tab Date of daily value \cr
qualcode \tab factor \tab Qualification code
}}
\usage{
  importDVs(staid, code = "00060", stat = "00003",
    sdate = "1851-01-01",
    edate = as.Date(Sys.Date(), format = "\%Y-\%m-\%d"))
}
\arguments{
  \item{staid}{is the USGS site identification number,
  usually eight digits long, but can be longer.  Users may
  search for surface-water sites and obtain station
  identification numbers using the USGS Site Web Service,
  \url{http://waterservices.usgs.gov/rest/Site-Service.html}
  (USGS, 2012e); using the National Water Information
  System: Mapper, \url{http://wdr.water.usgs.gov/nwisgmap/}
  (U.S. Geological Survey, 2012a); or using the National
  Water Information System: Web Interface to daily
  surface-water data,
  \url{http://waterdata.usgs.gov/nwis/dv/?referred_module=sw}
  (U.S. Geological Survey, 2012f).  The site identification
  number needs to be entered as a character, that is in
  quotes, because many USGS streamgage numbers begin with
  zero and the leading zero is necessary.}

  \item{code}{is the USGS parameter code, a 5-digit number
  used in the USGS computerized data system, National Water
  Information System (NWIS), to uniquely identify a
  specific hydrologic property or constituent.  A list of
  paramater codes is available at
  \url{http://nwis.waterdata.usgs.gov/usa/nwis/pmcodes}
  (U.S. Geological Survey, 2012b).}

  \item{stat}{is the USGS statistics code, a 5-digit number
  used in the USGS computerized data system, National Water
  Information System (NWIS), to uniquely identify specific
  statistics, such as daily mean, daily maximum, and daily
  minimum.  The default, 00003, is the mean daily value.  A
  list of statistics codes is available at
  \url{http://nwis.waterdata.usgs.gov/nwis/help/?read_file=stat&format=table}
  (U.S. Geological Survey, 2012c). Not all statistics are
  available at every gage.}

  \item{sdate}{is the start date of the time series, in the
  format yyyy-mm-dd, optional.}

  \item{edate}{is the end date of the time series, in the
  format yyyy-mm-dd, optional.}
}
\value{
  a data frame containing daily streamflow or other
  hydrologic data for the site specified during the dates
  specified (inclusive).  The USGS parameter code, code,
  and the statistics code, stat, are attributes of the data
  frame.
}
\description{
  Function to import daily hydrologic time series data
  given a USGS streamgage identification number.
}
\details{
  This function will import data from a WaterML1 service
  (current USGS hydrological data standard).  It will
  retrieve daily streamflow and continuous water-quality
  data from the USGS Daily Values Site Web Service
  \url{http://waterservices.usgs.gov/rest/DV-Service.html}
  (U.S. Geological Survey, 2012d).
}
\examples{
\dontrun{
# import mean daily streamflow for Red River of the North at Fargo, ND
q05054000 <- importDVs("05054000", sdate="2000-01-01", edate="2010-12-31")
head(q05054000)
# additional examples of how to this function follow
# import mean daily gage height for Red River of the North at Grand Forks, ND
gh05082500 <- importDVs("05082500", code="00065", sdate="2000-01-01", edate="2010-12-31")
# import mean daily specific conductance for Red River of the North at Grand Forks, ND
sc05082500<- importDVs("05082500", code="00095", sdate="2000-01-01", edate="2010-12-31")
# import mean daily water temperature for Red River of the North at Fargo, ND
temp05054000<- importDVs("05054000", code="00010", sdate="2000-01-01", edate="2010-12-31")
# import median daily pH for Red River of the North at Fargo, ND
pH05054000<- importDVs("05054000", code="00400", stat="00008", sdate="2000-01-01", edate="2010-12-31")
# examine the attributes of the data frame to show that the parameter code
# and statistics code are saved with the data frame
attributes(pH05054000)[c("code","stat")]
# import mean daily oxygen for Red River of the North at Fargo, ND
do05054000 <- importDVs("05054000", code="00300", sdate="2000-01-01", edate="2010-12-31")
# import mean daily turbidity for Red River of the North at Fargo, ND
turb05054000 <- importDVs("05054000", code="63680", sdate="2000-01-01", edate="2010-12-31")
}
}
\references{
  U.S. Geological Survey, 2012a, National Water Information
  System: Mapper, accessed September 7, 2012, at
  \url{http://wdr.water.usgs.gov/nwisgmap/}.

  U.S. Geological Survey, 2012b, Parameter code definition,
  National Water Information System: Web Interface,
  accessed September 7, 2012, at
  \url{http://nwis.waterdata.usgs.gov/usa/nwis/pmcodes}.

  U.S. Geological Survey, 2012c, Stat codes (stat_cd),
  National Water Information System: Web Interface,
  accessed September 7, 2012, at
  \url{http://nwis.waterdata.usgs.gov/nwis/help/?read_file=stat&format=table}.

  U.S. Geological Survey, 2012d, USGS daily values site web
  service: REST Web Services, accessed September 7, 2012,
  at
  \url{http://waterservices.usgs.gov/rest/DV-Service.html}.

  U.S. Geological Survey, 2012e, USGS site web service:
  REST Web Services, accessed September 7, 2012, at
  \url{http://waterservices.usgs.gov/rest/Site-Service.html}.

  U.S. Geological Survey, 2012f, USGS surface-water daily
  data for the Nation: National Water Information System:
  Web Interface, accessed September 7, 2012, at
  \url{http://waterdata.usgs.gov/nwis/dv/?referred_module=sw}.
}
\keyword{IO}
\keyword{ts}

