% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wav_2_flac.R
\name{wav_2_flac}
\alias{wav_2_flac}
\title{Convert .wav files to .flac}
\usage{
wav_2_flac(files = NULL, path = NULL, overwrite = FALSE, 
pb = TRUE, parallel = 1)
}
\arguments{
\item{files}{character vector with the names of files to be converted. If \code{NULL} all files in the working directory (or 'path' if supplied) are converted.}

\item{path}{Character string containing the directory path where the .wav files are located.
If \code{NULL} (default) then the current working directory is used.}

\item{overwrite}{Logical. Control whether a .flac sound file that is already in the working directory should be 
overwritten.}

\item{pb}{Logical argument to control if progress bar is shown. Default is \code{TRUE}. It can also be
set globally using the 'pb' option (see \code{\link{warbleR_options}}).}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing). It can also be
set globally using the 'parallel' option (see \code{\link{warbleR_options}}).}
}
\value{
.wav files saved in the working directory with same name as original mp3 files.
}
\description{
\code{wav_2_flac} converts several .wav files to .flac compressed lossless format
}
\details{
The function will convert all mp3 files in  working directory or 'path' supplied to wav format. \href{https://cran.r-project.org/package=bioacoustics}{bioacoustics package} must be installed when changing sampling rates (i.e. if 'samp.rate' is supplied). Note that sound files are normalized using \code{\link[tuneR]{normalize}} so they can be written by \code{\link[tuneR]{writeWave}}.

convert all .wav files in working directory to .flac compressed lossless format. It's just a silly wrapper over (\code{\link[seewave]{wav2flac}}) to simplify converting several files at once.
}
\examples{
\dontrun{
# create some .wav files
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))
writeWave(Phae.long4, file.path(tempdir(), "Phae.long4.wav"))

# Convert all files to .flac format
wav_2_flac(path = tempdir())

#check this folder!!
open_wd(tempdir())
}

}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
