% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/querxc.R
\name{querxc}
\alias{querxc}
\title{Access 'Xeno-Canto' recordings and metadata}
\usage{
querxc(qword, download = FALSE, X = NULL, file.name = c("Genus", "Specific_epithet"), 
parallel = 1, path = NULL, pb = TRUE)
}
\arguments{
\item{qword}{Character vector of length one indicating the genus, or genus and
species, to query 'Xeno-Canto' database. For example, \emph{Phaethornis} or \emph{Phaethornis longirostris}. 
More complex queries can be done by using search terms that follow the 
xeno-canto advance query syntax.This syntax uses tags to search within a particular aspect of the recordings 
(e.g. country, location, sound type). Tags are of the form tag:searchterm'. For instance, 'type:song' 
will search for all recordings in which the sound type description contains the word 'song'. 
Several tags can be included in the same query. The query "phaethornis cnt:belize' will only return 
results for birds in the genus \emph{Phaethornis} that were recorded in  Belize. 
See \href{https://www.xeno-canto.org/help/search}{Xeno-Canto's search help} for a full description and see examples below 
for queries using terms with more than one word.}

\item{download}{Logical argument. If \code{FALSE} only the recording file names and
associated metadata are downloaded. If \code{TRUE}, recordings are also downloaded to the working
directory as .mp3 files. Default is \code{FALSE}. Note that if the recording is already in the 
working directory (as when the downloading process has been interrupted) it will be skipped. 
Hence, resuming downloading processes will not start from scratch.}

\item{X}{Data frame with a 'Recording_ID' column and any other column listed in the file.name argument. Only the recordings listed in the data frame 
will be download (\code{download} argument is automatically set to \code{TRUE}). This can be used to select
the recordings to be downloaded based on their attributes.}

\item{file.name}{Character vector indicating the tags (or column names) to be included in the sound file names (if download = \code{TRUE}). Several tags can be included. If \code{NULL} only the 'Xeno-Canto' recording identification number ("Recording_ID") is used. Default is c("Genus", "Specific_epithet").
Note that recording id is always used (whether or not is listed by users) to avoid duplicated names.}

\item{parallel}{Numeric. Controls whether parallel computing is applied when downloading mp3 files.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing). Applied both when getting metadata and downloading files.}

\item{path}{Character string containing the directory path where the sound files will be saved. 
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}
}
\value{
If X is not provided the function returns a data frame with the following recording information: recording ID, Genus, Specific epithet, Subspecies, English name, Recordist, Country, Locality, Latitude, Longitude, Vocalization type, Audio file, License, URL, Quality, Time, Date. Sound files in .mp3 format are downloaded into the working directory if download = \code{TRUE} or if X is provided; a column indicating the  names of the downloaded files is included in the output data frame.
}
\description{
\code{querxc} downloads recordings and metadata from \href{https://www.xeno-canto.org/}{Xeno-Canto}.
}
\details{
This function queries for avian vocalization recordings in the open-access
online repository \href{https://www.xeno-canto.org/}{Xeno-Canto}. It can return recordings metadata
or download the associated sound files. Complex queries can be done by using search terms that follow the 
 xeno-canto advance query syntax (check "qword" argument description). 
 Files are double-checked after downloading and "empty" files are re-downloaded. 
 File downloading process can be interrupted and resume later as long as the working directory is the same.
 Maps of recording coordinates can be produced using 
\code{\link{xcmaps}}.
}
\examples{
\dontrun{
# search without downloading
df1 <- querxc(qword = 'Phaethornis anthophilus', download = FALSE)
View(df1)

# downloading files
querxc(qword = 'Phaethornis anthophilus', download = TRUE, path = tempdir())

# check this folder
tempdir()

## search using xeno-canto advance query ###
orth.pap <- querxc(qword = 'gen:orthonyx cnt:papua loc:tari', download = FALSE)
 
# download file using the output data frame as input
querxc(X = orth.pap, path = tempdir())

# use quotes for queries with more than 1 word (e.g. Costa Rica),note that the 
# single quotes are used for the whole 'qword' and double quotes for the 2-word term inside
#Phaeochroa genus in Costa Rica 
phae.cr <- querxc(qword = 'gen:phaeochroa cnt:"costa rica"', download = FALSE)

# several terms can be searched for in the same field
# search for all female songs in sound type
femsong <- querxc(qword = 'type:song type:female', download = FALSE)
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{xcmaps}}, 
\href{https://marce10.github.io/2016/12/22/Download_a_single_recording_for_each_species_in_a_site_from_Xeno-Canto.html}{blog post on accessing Xeno-Canto recordings}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
