% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waitress.R
\name{waitress}
\alias{waitress}
\alias{use_waitress}
\title{Waitress}
\usage{
use_waitress(color = "#697682", percent_color = "#333333")
}
\arguments{
\item{color, percent_color}{Color of waitress and color of percent text shown when
\code{theme} is set to \code{overlay-percent}.}
}
\description{
Programatically show and hide loading bars.
}
\details{
You can pipe the methods with \code{$}.
\code{Waitress$new()} and \code{call_waitress()} are equivalent.
}
\examples{
library(shiny)

ui <- fluidPage(
  use_waitress("red"), # dependencies
  sliderInput("set", "percentage", 1, 100, step = 5, value = 1)
)

server <- function(input, output, session){
 
  w <- Waitress$
   new()$  # call a waitress
  	start() # start waitress
	 
  observeEvent(input$set, {
    w$set(input$set) # set at percentage
  })
}

if(interactive()) shinyApp(ui, server)
 
}
