% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_workbook_server_powerpoint.R
\name{download_workbooks_server_powerpoint}
\alias{download_workbooks_server_powerpoint}
\title{Download workbook powerpoint from Tableau Server}
\usage{
download_workbooks_server_powerpoint(
  base_url,
  api_version = 3.8,
  site_id,
  token,
  workbook_id,
  path_to_save
)
}
\arguments{
\item{base_url}{The url of the Tableau Server.}

\item{api_version}{The api version; default set to 3.8 [this function works for version 3.8 and later].}

\item{site_id}{The site id of the Tableau server to access.}

\item{token}{The access token to the Tableau Rest API.}

\item{workbook_id}{The identifier of the workbook.}

\item{path_to_save}{Where to write the .pptx file to}
}
\value{
NULL.
}
\description{
Download workbook powerpoint from Tableau Server
}
\examples{
\dontrun{
# Download workbook PowerPoint from Tableau Server
download_workbooks_server_powerpoint(base_url = "https://tableau.server.com",
                                     api_version = 3.8,
                                     site_id = "your_site_id",
                                     token = "your_access_token",
                                     workbook_id = "your_workbook_id",
                                     path_to_save = "path/to/save/file.pptx")
}
}
\seealso{
Other tableau rest api: 
\code{\link{authenticate_server}()},
\code{\link{download_workbooks_server_pdf}()},
\code{\link{download_workbooks_server}()},
\code{\link{get_server_connected_apps}()},
\code{\link{get_server_datasources}()},
\code{\link{get_server_groups}()},
\code{\link{get_server_info}()},
\code{\link{get_server_jobs}()},
\code{\link{get_server_projects}()},
\code{\link{get_server_refresh_tasks}()},
\code{\link{get_server_schedules}()},
\code{\link{get_server_users}()},
\code{\link{get_server_views}()},
\code{\link{get_server_workbooks}()}
}
\concept{tableau rest api}
