% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dataset_summary_table.R
\name{find_minimum_value}
\alias{find_minimum_value}
\title{Find the minimum numeric value in a vector, ignoring non-numeric values}
\usage{
find_minimum_value(numeric_vector)
}
\arguments{
\item{numeric_vector}{A vector from which to find the minimum numeric value.}
}
\value{
The minimum numeric value in the input vector, or NA if none exist.
}
\description{
Find the minimum numeric value in a vector, ignoring non-numeric values
}
\examples{
# Find the minimum of a numeric vector
find_minimum_value(c(3, 1, 4, 1, 5, 9)) # Returns   1

# Find the minimum of a mixed vector with non-numeric values
find_minimum_value(c(3, 1, 4, "two", 5, 9)) # Returns   1

# Attempt to find the minimum of a vector with only non-numeric values
find_minimum_value(c("one", "two", "three")) # Returns NA
}
