% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return_assertions_message.R
\name{return_assertions_message}
\alias{return_assertions_message}
\title{Return Assertion Messages}
\usage{
return_assertions_message(
  collection,
  collection_name,
  fail = "stop",
  silent = FALSE,
  output_map = NULL
)
}
\arguments{
\item{collection}{An object with the class "AssertCollection".}

\item{collection_name}{The name of the collection. This name is mentioned in the messages.}

\item{fail}{"stop" or "warning". If the assertions fail, an error is returned and the script output is stopped. If "warning", only a warning is returned.}

\item{silent}{If FALSE (default), the success message is printed in the console. If TRUE, it is not shown.}

\item{output_map}{A map, like 1. Read data, where the file is stored.}
}
\value{
The message indicating whether the assertion test has passed or failed.
}
\description{
This function returns a message indicating whether an assertion test has passed or failed.
An "assertion collection" from the checkmate package must be provided. The message can be returned as an error or a warning.
For some assertions, only warnings are allowed, as an error would stop the script from running.
This is done for the following assertions: percentage missing values, duplicates, subset, and set_equal.
}
