% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-base-url.R
\name{vw_set_base_url}
\alias{vw_set_base_url}
\title{Set base URL}
\usage{
vw_set_base_url(url)
}
\arguments{
\item{url}{\code{character} URL to use as the base URL.}
}
\value{
\code{character} called for side effects, it returns the previous value
invisibly.
}
\description{
This is useful for specs where data is specified using a URL.
Using this function to set the base URL, you can specify the data URL
in specs using the relative path from the base.

For example, this
\href{https://vega.github.io/vega-lite/examples/point_2d.html}{Vega-Lite example}
uses the base URL \verb{https://cdn.jsdelivr.net/npm/vega-datasets@2}. In a spec,
instead of specifying:\preformatted{data = "https://cdn.jsdelivr.net/npm/vega-datasets@2/data/cars.json"
}

You can call:\preformatted{vw_set_base_url("https://cdn.jsdelivr.net/npm/vega-datasets@2")
}

Then specify:\preformatted{data = "data/cars.json"
}

This function sets the value of \code{getOption("vega-embed")$loader$baseURL}.
You need set it only once in a session or RMarkdown file.
}
\examples{
 # this is the URL used for Vega datasets
 previous <- vw_set_base_url("https://cdn.jsdelivr.net/npm/vega-datasets@2")

 # reset to previous value
 vw_set_base_url(previous)
}
